// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

/**
 * Thrown in case the command line arguments do not match the required syntax.
 */
public class AmbiguousArgsException extends ArgsSyntaxException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new ambiguous args exception.
	 *
	 * @param aArgs the args
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public AmbiguousArgsException( String[] aArgs, String aMessage, String aErrorCode ) {
		super( aArgs, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous args exception.
	 *
	 * @param aArgs the args
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public AmbiguousArgsException( String[] aArgs, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aArgs, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous args exception.
	 *
	 * @param aArgs the args
	 * @param message the message
	 * @param cause the cause
	 */
	public AmbiguousArgsException( String[] aArgs, String message, Throwable cause ) {
		super( aArgs, message, cause );
	}

	/**
	 * Instantiates a new ambiguous args exception.
	 *
	 * @param aArgs the args
	 * @param message the message
	 */
	public AmbiguousArgsException( String[] aArgs, String message ) {
		super( aArgs, message );
	}

	/**
	 * Instantiates a new ambiguous args exception.
	 *
	 * @param aArgs the args
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public AmbiguousArgsException( String[] aArgs, Throwable aCause, String aErrorCode ) {
		super( aArgs, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new ambiguous args exception.
	 *
	 * @param aArgs the args
	 * @param cause the cause
	 */
	public AmbiguousArgsException( String[] aArgs, Throwable cause ) {
		super( aArgs, cause );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
