// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import org.refcodes.struct.Relation;

/**
 * The Class EnumOption.
 *
 * @author steiner
 * 
 * @param <T> the generic type
 */
public class EnumOption<T extends Enum<T>> extends AbstractOption<T> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new enum option.
	 *
	 * @param aShortOption the short option
	 * @param aLongOption the long option
	 * @param aType the type
	 * @param aAlias the option arg name
	 * @param aDescription the description
	 */
	public EnumOption( String aShortOption, String aLongOption, Class<T> aType, String aAlias, String aDescription ) {
		super( aShortOption, aLongOption, aType, aAlias, aDescription );
	}

	/**
	 * Instantiates a new enum option.
	 *
	 * @param aLongOption the long option
	 * @param aType the type
	 * @param aAlias the option arg name
	 * @param aDescription the description
	 */
	public EnumOption( String aLongOption, Class<T> aType, String aAlias, String aDescription ) {
		this( null, aLongOption, aType, aAlias, aDescription );
	}

	/**
	 * Instantiates a new enum option.
	 *
	 * @param aProperty The key (= alias) and the value for the operand.
	 * @param aType the type
	 */
	public EnumOption( Relation<String, T> aProperty, Class<T> aType ) {
		super( aProperty, aType );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected T toType( String aArg ) throws ParseArgsException {
		IllegalArgumentException theFirstCause = null;
		try {
			return Enum.valueOf( getType(), aArg );
		}
		catch ( IllegalArgumentException e1 ) {
			theFirstCause = e1;
			try {
				return Enum.valueOf( getType(), aArg.toUpperCase() );
			}
			catch ( IllegalArgumentException e2 ) {
				try {
					return Enum.valueOf( getType(), aArg.toLowerCase() );
				}
				catch ( IllegalArgumentException e3 ) {
					throw new ParseArgsException( new String[] {
							aArg
					}, "Invalid argument \"" + aArg + "\" for option <" + getAlias() + ">.", theFirstCause );
				}
			}
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
