// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

/**
 * The {@link Synopsis} interface defines those methods required to create a
 * human readable usage {@link String} from the implementing instance.
 */
public interface Synopsis {

	/**
	 * Returns the human readable (verbose) syntax of implementing class
	 * ATTENTION: As of different parenthesis settings for some notations
	 * regarding the root {@link Syntaxable} and the child {@link Syntaxable}s,
	 * the method {@link Syntaxable#toSyntax(SyntaxNotation, String, String, String)} is
	 * called from inside a {@link Syntaxable} hierarchy. In case the syntax is
	 * to be retrieved from the root {@link Syntaxable} or an encapsulating and
	 * different type, then the applicable method to be called is
	 * {@link #toSynopsis(SyntaxNotation)}, as for some notations it will for
	 * example not create the most outer braces.
	 * 
	 * This method uses the {@link SyntaxNotation#REFCODES} be default!
	 * 
	 * @return The human readable (verbose) command line arguments syntax.
	 */
	default String toSynopsis() {
		return toSynopsis( SyntaxNotation.REFCODES );
	}

	/**
	 * Returns the human readable (verbose) syntax of implementing class
	 * ATTENTION: As of different parenthesis settings for some notations
	 * regarding the root {@link Syntaxable} and the child {@link Syntaxable}s,
	 * the method {@link Syntaxable#toSyntax(SyntaxNotation, String, String, String)} is
	 * called from inside a {@link Syntaxable} hierarchy. In case the syntax is
	 * to be retrieved from the root {@link Syntaxable} or an encapsulating and
	 * different type, then the applicable method to be called is
	 * {@link #toSynopsis(SyntaxNotation)}, as for some notations it will for
	 * example not create the most outer braces.
	 * 
	 * @param aSyntaxNotation The syntax notation used for generating the
	 *        command line arguments syntax.
	 * 
	 * @return The human readable (verbose) command line arguments syntax.
	 */
	default String toSynopsis( SyntaxNotation aSyntaxNotation ) {
		return toSynopsis( aSyntaxNotation, null, null, null );
	}

	/**
	 * Returns the human readable (verbose) syntax of implementing class
	 * ATTENTION: As of different parenthesis settings for some notations
	 * regarding the root {@link Syntaxable} and the child {@link Syntaxable}s,
	 * the method {@link Syntaxable#toSyntax(SyntaxNotation, String, String, String)} is
	 * called from inside a {@link Syntaxable} hierarchy. In case the syntax is
	 * to be retrieved from the root {@link Syntaxable} or an encapsulating and
	 * different type, then the applicable method to be called is
	 * {@link #toSynopsis(SyntaxNotation)}, as for some notations it will for
	 * example not create the most outer braces.
	 * 
	 * This method uses the {@link SyntaxNotation#REFCODES} be default!
	 *
	 * @param aOptEscCode The escape code to be used when processing an option,
	 *        e.g. this can be an ANSI Escape-Code to highlight the option.
	 * @param aParamEscCode The escape code to be used when processing am
	 *        argument, e.g. this can be an ANSI Escape-Code to highlight the
	 *        option.
	 * @param aResetEscCode The escape code to close (reset) any Escape-Code
	 *        being set before.
	 * 
	 * @return The human readable (verbose) command line arguments syntax.
	 */
	default String toSynopsis( String aOptEscCode, String aParamEscCode, String aResetEscCode ) {
		return toSynopsis( SyntaxNotation.REFCODES, aOptEscCode, aParamEscCode, aResetEscCode );
	}

	/**
	 * Returns the human readable (verbose) syntax of implementing class
	 * ATTENTION: As of different parenthesis settings for some notations
	 * regarding the root {@link Syntaxable} and the child {@link Syntaxable}s,
	 * the method {@link Syntaxable#toSyntax(SyntaxNotation, String, String, String)} is
	 * called from inside a {@link Syntaxable} hierarchy. In case the syntax is
	 * to be retrieved from the root {@link Syntaxable} or an encapsulating and
	 * different type, then the applicable method to be called is
	 * {@link #toSynopsis(SyntaxNotation)}, as for some notations it will for
	 * example not create the most outer braces.
	 *
	 * @param aSyntaxNotation The syntax notation used for generating the
	 *        command line arguments syntax.
	 * @param aOptEscCode The escape code to be used when processing an option,
	 *        e.g. this can be an ANSI Escape-Code to highlight the option.
	 * @param aParamEscCode The escape code to be used when processing am
	 *        argument, e.g. this can be an ANSI Escape-Code to highlight the
	 *        option.
	 * @param aResetEscCode The escape code to close (reset) any Escape-Code
	 *        being set before.
	 * 
	 * @return The human readable (verbose) command line arguments syntax.
	 */
	String toSynopsis( SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode );
}