// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

/**
 * The {@link SyntaxNotation} is used by a the
 * {@link Syntaxable#toSyntax(SyntaxNotation, String, String, String)} method to
 * determine which notation to be used for the generated syntax.
 */
public enum SyntaxNotation {

	/**
	 * A notation which the author of this code believes to unambiguously
	 * describe a command line utility's argument syntax; as defined by the
	 * means of this <code>refcodes-cli</code> artifact.
	 */
	REFCODES,

	/**
	 * A syntax notation derived from GNU and POSIX utility conventions and
	 * utility argument syntax.
	 * 
	 * @see "http://www.gnu.org/software/libc/manual/html_node/Argument-Syntax.html"
	 * @see "http://pubs.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap12.html"
	 */
	GNU_POSIX
}
