/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.Flag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;

public class StackOverflowTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testParserStackOverflow1() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-r", null, "opt1", "Your description for option r with argument opt1");
        StringOption stringOption2 = new StringOption("-S", null, "opt2", "Your description for option S with argument opt2");
        StringOperand stringOperand = new StringOperand("arg1", "Your description for arg1");
        StringOperand stringOperand2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand stringOperand3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand stringOperand4 = new StringOperand("arg4", "Your description for arg4");
        Flag flag = new Flag(null, "--test", null, "Your description for test");
        StringOption stringOption3 = new StringOption("-A", null, "opt3", "Your description for option A with argument opt3");
        AndCondition andCondition = new AndCondition(new Syntaxable[]{stringOption, stringOption2, stringOption3, stringOperand, stringOperand2, stringOperand3, stringOperand4, flag});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        argsParserImpl.withName("MyProgramm");
        argsParserImpl.withSyntaxNotation(SyntaxNotation.GNU_POSIX);
        argsParserImpl.printSynopsis();
        argsParserImpl.printSeparatorLn();
        argsParserImpl.printOptions();
        argsParserImpl.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "--test", "-A", "AAAAA"});
        if (IS_LOG_TESTS) {
            System.out.println("r    :=" + (String)stringOption.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("S    :=" + (String)stringOption2.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg1 :=" + (String)stringOperand.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg2 :=" + (String)stringOperand2.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg3 :=" + (String)stringOperand3.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg4 :=" + (String)stringOperand4.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("test :=" + flag.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("A    :=" + (String)stringOption3.getValue());
        }
        Assertions.assertEquals((Object)stringOption.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)stringOperand.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)stringOperand2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)stringOperand3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)stringOperand4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)flag.getValue(), (Object)true);
        Assertions.assertEquals((Object)stringOption3.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow2() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-r", null, "opt1", "Your description for option r with argument opt1");
        StringOption stringOption2 = new StringOption("-S", null, "opt2", "Your description for option S with argument opt2");
        StringOperand stringOperand = new StringOperand("arg1", "Your description for arg1");
        StringOperand stringOperand2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand stringOperand3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand stringOperand4 = new StringOperand("arg4", "Your description for arg4");
        Flag flag = new Flag(null, "--test", null, "Your description for test");
        StringOption stringOption3 = new StringOption("-A", null, "opt3", "Your description for option A with argument opt3");
        AndCondition andCondition = new AndCondition(new Syntaxable[]{stringOption, stringOption2, stringOption3, stringOperand, stringOperand2, stringOperand3, stringOperand4, new AnyCondition(new Syntaxable[]{flag})});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        argsParserImpl.withName("MyProgramm");
        argsParserImpl.withSyntaxNotation(SyntaxNotation.GNU_POSIX);
        argsParserImpl.printSynopsis();
        argsParserImpl.printSeparatorLn();
        argsParserImpl.printOptions();
        argsParserImpl.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "-A", "AAAAA"});
        if (IS_LOG_TESTS) {
            System.out.println("r    :=" + (String)stringOption.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("S    :=" + (String)stringOption2.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg1 :=" + (String)stringOperand.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg2 :=" + (String)stringOperand2.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg3 :=" + (String)stringOperand3.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg4 :=" + (String)stringOperand4.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("test :=" + flag.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("A    :=" + (String)stringOption3.getValue());
        }
        Assertions.assertEquals((Object)stringOption.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)stringOperand.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)stringOperand2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)stringOperand3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)stringOperand4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)flag.getValue(), (Object)false);
        Assertions.assertEquals((Object)stringOption3.getValue(), (Object)"AAAAA");
    }
}

