/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.refcodes.cli.ArgsParserMixin;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.Example;
import org.refcodes.cli.Operand;
import org.refcodes.cli.RootConditionAccessor;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.component.Resetable;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.mixin.TitleAccessor;
import org.refcodes.textual.Font;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxGridAccessor;

public interface ArgsParser
extends ArgsParserMixin<ArgsParser>,
TitleAccessor.TitleProperty,
TitleAccessor.TitleBuilder<ArgsParser>,
NameAccessor.NameProperty,
NameAccessor.NameBuilder<ArgsParser>,
DescriptionAccessor.DescriptionProperty,
DescriptionAccessor.DescriptionBuilder<ArgsParser>,
Resetable,
RootConditionAccessor,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<ArgsParser>,
ResetEscapeCodeAccessor.ResetEscapeCodeProperty,
ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<ArgsParser>,
TextBoxGridAccessor.TextBoxGridProperty,
TextBoxGridAccessor.TextBoxGridBuilder<ArgsParser> {
    public void errorLn(String var1);

    default public List<? extends Operand<?>> evalArgs(List<String> list) throws ArgsSyntaxException {
        return this.evalArgs(list.toArray(new String[list.size()]));
    }

    public List<? extends Operand<?>> evalArgs(String[] var1) throws ArgsSyntaxException;

    public String getCopyrightNote();

    public String getDescription();

    public String getLicenseNote();

    public String getCommandEscapeCode();

    public String getDescriptionEscapeCode();

    public String getParamEscapeCode();

    public String getOptionEscapeCode();

    public String getBannerEscapeCode();

    public String getLineSeparatorEscapeCode();

    public char getSeparatorLnChar();

    public String getBannerBorderEscapeCode();

    @Override
    public ArgsSyntax getArgsSyntax();

    public List<Example> getExamples();

    default public void addExample(String string, Operand<?> ... operandArray) {
        this.addExample(new Example(string, operandArray));
    }

    public void addExample(Example var1);

    default public ArgsParser withExample(Example example) {
        this.addExample(example);
        return this;
    }

    default public ArgsParser withExample(String string, Operand<?> ... operandArray) {
        this.addExample(string, operandArray);
        return this;
    }

    default public ArgsParser withExamples(Collection<Example> collection) {
        for (Example example : collection) {
            this.addExample(example);
        }
        return this;
    }

    default public ArgsParser withExamples(Example[] exampleArray) {
        for (Example example : exampleArray) {
            this.addExample(example);
        }
        return this;
    }

    public void printBanner();

    default public void printBody() {
        if (this.getLicenseNote() != null) {
            this.printLicenseNote();
            this.printSeparatorLn();
        }
        this.printSynopsis();
        this.printSeparatorLn();
        if (this.getDescription() != null) {
            this.printDescription();
            this.printSeparatorLn();
        }
        if (this.getArgsSyntax() != null) {
            this.printOptions();
            this.printSeparatorLn();
        }
        if (this.getExamples() != null && this.getExamples().size() != 0) {
            this.printExamples();
            this.printSeparatorLn();
        }
        if (this.getCopyrightNote() != null) {
            this.printCopyrightNote();
            this.printSeparatorLn();
        }
    }

    public void printCopyrightNote();

    public void printDescription();

    public void printExamples();

    default public void printHelp() {
        this.printBanner();
        this.printBody();
    }

    public void printLicenseNote();

    public void printLn();

    public void printLn(String var1);

    public void printOptions();

    public void printSeparatorLn();

    public void printSynopsis();

    public void setBannerFont(Font var1);

    public void setBannerFontPalette(char[] var1);

    public void setConsoleWidth(int var1);

    public void setCopyrightNote(String var1);

    public void setErrorOut(PrintStream var1);

    public void setLicenseNote(String var1);

    public void setLineBreak(String var1);

    public void setMaxConsoleWidth(int var1);

    public void setDescriptionEscapeCode(String var1);

    public void setCommandEscapeCode(String var1);

    public void setParamEscapeCode(String var1);

    public void setOptionEscapeCode(String var1);

    public void setBannerEscapeCode(String var1);

    public void setLineSeparatorEscapeCode(String var1);

    public void setBannerBorderEscapeCode(String var1);

    public void setSeparatorLnChar(char var1);

    public void setStandardOut(PrintStream var1);

    public void setSyntaxNotation(SyntaxNotation var1);

    default public ArgsParser withTextBoxGrid(TextBoxGrid textBoxGrid) {
        this.setTextBoxGrid(textBoxGrid);
        return this;
    }

    default public ArgsParser withBannerFont(Font font) {
        this.setBannerFont(font);
        return this;
    }

    default public ArgsParser withBannerFontPalette(char[] cArray) {
        this.setBannerFontPalette(cArray);
        return this;
    }

    default public ArgsParser withConsoleWidth(int n) {
        this.setConsoleWidth(n);
        return this;
    }

    default public ArgsParser withCopyrightNote(String string) {
        this.setCopyrightNote(string);
        return this;
    }

    default public ArgsParser withDescription(String string) {
        this.setDescription(string);
        return this;
    }

    default public ArgsParser withErrorOut(PrintStream printStream) {
        this.setErrorOut(printStream);
        return this;
    }

    default public ArgsParser withEscapeCodesEnabled(boolean bl) {
        this.setEscapeCodesEnabled(bl);
        return this;
    }

    @Override
    default public ArgsParser withEvalArgs(List<String> list) throws ArgsSyntaxException {
        this.evalArgs(list.toArray(new String[list.size()]));
        return this;
    }

    default public ArgsParser withLicenseNote(String string) {
        this.setLicenseNote(string);
        return this;
    }

    default public ArgsParser withLineBreak(String string) {
        this.setLineBreak(string);
        return this;
    }

    default public ArgsParser withMaxConsoleWidth(int n) {
        this.setMaxConsoleWidth(n);
        return this;
    }

    default public ArgsParser withName(String string) {
        this.setName(string);
        return this;
    }

    default public ArgsParser withDescriptionEscapeCode(String string) {
        this.setDescriptionEscapeCode(string);
        return this;
    }

    default public ArgsParser withCommandEscapeCode(String string) {
        this.setCommandEscapeCode(string);
        return this;
    }

    default public ArgsParser withParamEscapeCode(String string) {
        this.setParamEscapeCode(string);
        return this;
    }

    default public ArgsParser withOptionEscapeCode(String string) {
        this.setParamEscapeCode(string);
        return this;
    }

    default public ArgsParser withBannerEscapeCode(String string) {
        this.setBannerEscapeCode(string);
        return this;
    }

    default public ArgsParser withLineSeparatorEscapeCode(String string) {
        this.setLineSeparatorEscapeCode(string);
        return this;
    }

    default public ArgsParser withBannerBorderEscapeCode(String string) {
        this.setBannerEscapeCode(string);
        return this;
    }

    @Override
    default public ArgsParser withEvalArgs(String[] stringArray) throws ArgsSyntaxException {
        this.evalArgs(stringArray);
        return this;
    }

    default public ArgsParser withResetEscapeCode(String string) {
        this.setResetEscapeCode(string);
        return this;
    }

    default public ArgsParser withSeparatorLnChar(char c) {
        this.setSeparatorLnChar(c);
        return this;
    }

    default public ArgsParser withStandardOut(PrintStream printStream) {
        this.setStandardOut(printStream);
        return this;
    }

    default public ArgsParser withSyntaxNotation(SyntaxNotation syntaxNotation) {
        this.setSyntaxNotation(syntaxNotation);
        return this;
    }

    default public ArgsParser withTitle(String string) {
        this.setTitle(string);
        return this;
    }
}

