/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.Term;

public class AllCondition
extends AbstractCondition {
    public AllCondition(Term aArg) {
        super("All (ALL) command line arguments passed are to be consumed by the according syntax branches.", aArg);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        Operand<?>[] theResult;
        try {
            theResult = this._children[0].parseArgs(aArgs, aOptions, aCliCtx);
        }
        catch (ArgsSyntaxException e) {
            this._exception = e;
            throw this._exception;
        }
        String[] theRemainderArgs = AllCondition.toArgsDiff(aArgs, theResult);
        if (theRemainderArgs != null && theRemainderArgs.length != 0) {
            String thePossibleCause = this.toPossibleCause(theRemainderArgs);
            thePossibleCause = thePossibleCause.length() > 0 ? " " + thePossibleCause : thePossibleCause;
            this._exception = new SuperfluousArgsException("Failed as of superfluous " + this.toString(theRemainderArgs) + (theRemainderArgs.length == 1 ? " argument" : " arguments") + ", though the arguments must be matched completely (ALL) by the syntax branches!" + thePossibleCause, theRemainderArgs, this);
            throw this._exception;
        }
        return theResult;
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        if (this._children != null && this._children.length > 0) {
            if (this._children.length == 1) {
                return this._children[0].toSynopsis(aCliCtx);
            }
            String theSynopsis = "";
            Term[] termArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Term eChild = termArray[n2];
                if (theSynopsis.length() != 0) {
                    theSynopsis = String.valueOf(theSynopsis) + " ";
                }
                theSynopsis = String.valueOf(theSynopsis) + eChild.toSyntax(aCliCtx);
                ++n2;
            }
            return theSynopsis;
        }
        return "";
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        if (this._children != null && this._children.length > 0) {
            String theSyntax = "";
            Term[] termArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Term eChild = termArray[n2];
                if (theSyntax.length() != 0) {
                    theSyntax = String.valueOf(theSyntax) + " ";
                }
                if (aCliCtx.getSyntaxMetrics().getAllSymbol() != null && aCliCtx.getSyntaxMetrics().getAllSymbol().length() != 0) {
                    theSyntax = String.valueOf(theSyntax) + aCliCtx.getSyntaxMetrics().getAllSymbol() + aCliCtx.getSyntaxMetrics().getBeginListSymbol() + " ";
                }
                theSyntax = String.valueOf(theSyntax) + eChild.toSyntax(aCliCtx);
                if (aCliCtx.getSyntaxMetrics().getAllSymbol() != null && aCliCtx.getSyntaxMetrics().getAllSymbol().length() != 0) {
                    theSyntax = String.valueOf(theSyntax) + " " + aCliCtx.getSyntaxMetrics().getEndListSymbol();
                }
                ++n2;
            }
            return theSyntax;
        }
        return "";
    }

    protected Term getChild() {
        return this._children[0];
    }

    /*
     * WARNING - void declaration
     */
    private String toPossibleCause(String[] aRemainderArgs) {
        String theMessage = "";
        Condition[] theParents = this.toConditions(aRemainderArgs);
        if (theParents != null && theParents.length != 0) {
            Condition[] conditionArray = theParents;
            int n = theParents.length;
            int n2 = 0;
            while (n2 < n) {
                Condition eCondition = conditionArray[n2];
                ArgsSyntaxException eException = eCondition.getException();
                if (eException != null) {
                    eException = eException.toRootMatchCause();
                    theMessage = String.valueOf(theMessage) + (theMessage.length() != 0 ? " " : "") + "Possible cause" + ": " + eException.toShortMessage();
                    if (eException.getSuppressed() != null && eException.getSuppressed().length != 0) {
                        Throwable[] throwableArray = eException.getSuppressed();
                        int n3 = throwableArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Throwable eSuppressed = throwableArray[n4];
                            Throwable throwable = eSuppressed;
                            if (throwable instanceof ArgsSyntaxException) {
                                void eSyntaxException;
                                ArgsSyntaxException cfr_ignored_0 = (ArgsSyntaxException)((Object)throwable);
                                ArgsSyntaxException cfr_ignored_1 = (ArgsSyntaxException)((Object)throwable);
                                theMessage = String.valueOf(theMessage) + " " + eSyntaxException.toRootMatchCause().toShortMessage();
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return theMessage;
    }

    private String toString(String[] aArgs) {
        StringBuilder theBuilder = new StringBuilder();
        int i = 0;
        while (i < aArgs.length) {
            theBuilder.append("\"" + aArgs[i] + "\"");
            if (i < aArgs.length - 1) {
                theBuilder.append(", ");
            }
            ++i;
        }
        return theBuilder.toString();
    }
}

