/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;

public class XorCondition
extends AbstractCondition {
    public XorCondition(Term ... aArgs) {
        super("Exactly one (XOR) syntax branch must match from the command line arguments.", aArgs);
    }

    protected XorCondition(String aDescription, Term ... aArgs) {
        super(aDescription, aArgs);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList<AnyCondition> theOptionals = new ArrayList<AnyCondition>();
        Operand<?>[] theResult = null;
        Term theResultSyntaxable = null;
        Operand<?>[] eOperands = null;
        int theMatchCount = this._children.length;
        ArgsSyntaxException theCause = null;
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Term eChild = termArray[n2];
            if (eChild instanceof AnyCondition) {
                theOptionals.add((AnyCondition)eChild);
            }
            try {
                eOperands = theResult != null && eChild instanceof Operand && theResultSyntaxable instanceof Option ? eChild.parseArgs(XorCondition.toArgsDiff(aArgs, theResult), aOptions, aCliCtx) : eChild.parseArgs(aArgs, aOptions, aCliCtx);
                if (eOperands != null && eOperands.length == 0) {
                    eOperands = null;
                }
            }
            catch (ArgsSyntaxException e) {
                if (theCause == null) {
                    theCause = e;
                } else {
                    theCause.addSuppressed((Throwable)((Object)e));
                }
                --theMatchCount;
            }
            if ((theResult = XorCondition.removeDuplicates(theResult, eOperands)) != null && eOperands != null) {
                this._exception = new AmbiguousArgsException("More than one syntax branch matched the command line arguments, though exactly one (XOR) syntax branch must match!", aArgs, (Term)this, (Throwable)((Object)theCause));
                throw this._exception;
            }
            if (eOperands != null && eOperands.length != 0 && theResult == null) {
                theResult = eOperands;
                theResultSyntaxable = eChild;
            }
            eOperands = null;
            ++n2;
        }
        if (theMatchCount == 0) {
            this._exception = new UnknownArgsException("No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match!", aArgs, (Term)this, (Throwable)((Object)theCause));
            throw this._exception;
        }
        if (theMatchCount > 1) {
            if (theOptionals.size() > 1 && aArgs != null && aArgs.length > 0) {
                this._exception = new AmbiguousArgsException("No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", aArgs, (Term)this, (Throwable)((Object)theCause));
                throw this._exception;
            }
            if ((theMatchCount -= theOptionals.size()) > 1) {
                this._exception = new AmbiguousArgsException("No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", aArgs, (Term)this, (Throwable)((Object)theCause));
                throw this._exception;
            }
        }
        if (theResult != null) {
            return theResult;
        }
        if (theOptionals.size() == 0) {
            return new Operand[0];
        }
        this._exception = new UnknownArgsException("No syntax branch (fully) matched the provided command line arguments, though one (XOR) syntax branch must match!", aArgs, (Term)this, (Throwable)((Object)theCause));
        throw this._exception;
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        String theSynopsis = "";
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Term eChild = termArray[n2];
            if (theSynopsis.length() != 0) {
                theSynopsis = String.valueOf(theSynopsis) + (aCliCtx.getSyntaxMetrics().getXorSymbol() != null && aCliCtx.getSyntaxMetrics().getXorSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getXorSymbol() + " " : " ");
            }
            theSynopsis = String.valueOf(theSynopsis) + eChild.toSyntax(aCliCtx);
            ++n2;
        }
        return theSynopsis;
    }

    private static Operand<?>[] removeDuplicates(Operand<?>[] aOperands, Operand<?>[] aDuplicates) {
        if (aOperands != null && aDuplicates != null) {
            Operand<?> eOperand;
            ArrayList theResult = new ArrayList();
            Operand<?>[] operandArray = aOperands;
            int n = aOperands.length;
            int n2 = 0;
            while (n2 < n) {
                eOperand = operandArray[n2];
                theResult.add(eOperand);
                ++n2;
            }
            operandArray = aDuplicates;
            n = aDuplicates.length;
            n2 = 0;
            while (n2 < n) {
                eOperand = operandArray[n2];
                if (theResult.contains(eOperand)) {
                    theResult.remove(eOperand);
                }
                ++n2;
            }
            aOperands = theResult.isEmpty() ? null : theResult.toArray(new Operand[theResult.size()]);
        }
        return aOperands;
    }
}

