/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.EnabledAccessor;
import org.refcodes.struct.Relation;

public class NoneOperand
extends AbstractOperand<Boolean>
implements EnabledAccessor {
    public static final String ALIAS = "none";

    public NoneOperand(Relation<String, Boolean> aProperty) {
        super(aProperty, Boolean.class);
    }

    public NoneOperand(String aDescription) {
        super(Boolean.class, ALIAS, aDescription);
    }

    public NoneOperand(String aAlias, String aDescription) {
        super(Boolean.class, aAlias, aDescription);
    }

    public boolean isEnabled() {
        Boolean theValue = (Boolean)this.getValue();
        if (theValue != null) {
            return theValue;
        }
        return false;
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aOptions, CliContext aCliContext) throws ArgsSyntaxException {
        boolean isEmpty = aArgs == null || aArgs.length == 0;
        this.setValue(isEmpty);
        if (!isEmpty) {
            this._exception = new UnknownArgsException("No arguments are expected but <" + aArgs.length + "> arguments have been provided!", aArgs, this);
            throw this._exception;
        }
        return new Operand[]{this};
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toArgumentEscapeCode() + aCliCtx.getSyntaxMetrics().getEmptySymbol() + aCliCtx.toResetEscapeCode();
    }

    public NoneOperand withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }

    @Override
    protected Boolean toType(String aArg) {
        return aArg == null || aArg.isEmpty();
    }
}

