/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;

public abstract class AbstractCondition
extends AbstractTerm
implements Condition {
    protected Term[] _children;

    public AbstractCondition(String aDescription, Term ... aElements) {
        super(aDescription);
        this._children = aElements;
    }

    @Override
    public int getMatchCount() {
        int theMatchCount = 0;
        for (Term eTerm : this._children) {
            theMatchCount += eTerm.getMatchCount();
        }
        return theMatchCount;
    }

    @Override
    public void reset() {
        super.reset();
        for (Term eTerm : this._children) {
            eTerm.reset();
        }
    }

    @Override
    public <T extends Operand<?>> T toOperand(String aAlias, Class<T> aType) {
        for (Term eSyntaxable : this._children) {
            Condition eCondition;
            Operand eOperand;
            if (eSyntaxable instanceof Operand) {
                eOperand = (Operand)eSyntaxable;
                boolean eTypeMatch = true;
                boolean eAliasMatch = true;
                if (aAlias != null && aAlias.length() != 0) {
                    eAliasMatch = aAlias.equals(eOperand.getAlias());
                }
                if (aType != null) {
                    eTypeMatch = aType.isAssignableFrom(eOperand.getClass());
                }
                if (!eTypeMatch || !eAliasMatch) continue;
                return (T)eOperand;
            }
            if (!(eSyntaxable instanceof Condition) || (eOperand = (eCondition = (Condition)eSyntaxable).toOperand(aAlias, aType)) == null) continue;
            return (T)eOperand;
        }
        return null;
    }

    @Override
    public Operand<?>[] toOperands() {
        ArrayList theResult = new ArrayList();
        for (Term eSyntaxable : this._children) {
            Operand<?>[] theOperands;
            if (eSyntaxable instanceof Operand) {
                theResult.add((Operand)eSyntaxable);
            }
            if (!(eSyntaxable instanceof Condition) || (theOperands = ((Condition)eSyntaxable).toOperands()) == null || theOperands.length == 0) continue;
            for (Operand<?> eOperand : theOperands) {
                theResult.add(eOperand);
            }
        }
        return theResult.toArray(new Operand[theResult.size()]);
    }

    @Override
    public CliSchema toSchema() {
        CliSchema[] theSchemas = null;
        if (this._children != null && this._children.length != 0) {
            theSchemas = new CliSchema[this._children.length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = this._children[i].toSchema();
            }
        }
        CliSchema theSchema = CliSchema.builder().withInstance(this).withDescription(this._description).withChildren(theSchemas).build();
        theSchema.put("MATCH_COUNT", this.getMatchCount());
        if (this._exception != null) {
            theSchema.put("EXCEPTION", this._exception);
        }
        return theSchema;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [children=" + Arrays.toString(this._children) + "]";
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        Object theSyntax = this.toSynopsis(aCliCtx);
        if (((String)theSyntax).length() > 0 && this._children != null && this._children.length > 1) {
            theSyntax = aCliCtx.getSyntaxMetrics().getBeginListSymbol() + " " + (String)theSyntax + " " + aCliCtx.getSyntaxMetrics().getEndListSymbol();
        }
        return theSyntax;
    }

    @Override
    public <V> V toValue(String aAlias) {
        for (Term eElement : this._children) {
            Object eValue = eElement.toValue(aAlias);
            if (eValue == null) continue;
            return eValue;
        }
        return null;
    }

    public Term[] getChildren() {
        return this._children;
    }

    @Override
    public boolean isVisible() {
        if (super.isVisible()) {
            for (Term eChild : this._children) {
                if (!eChild.isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

