// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

public class ComponentX {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private ComponentA a;
	private ComponentA1 a1;
	private ComponentA2 a2;
	private ComponentB b;
	private ComponentB1 b1;
	private ComponentB2 b2;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ComponentX( ComponentB2 b2 ) {
		this.b2 = b2;
	}

	public ComponentX( ComponentA a, ComponentB b ) {
		this.a = a;
		this.b = b;
	}

	public ComponentX( ComponentA1 a1, ComponentA2 a2 ) {
		this.a1 = a1;
		this.a2 = a2;
	}

	public ComponentX( ComponentA1 a1, ComponentA2 a2, ComponentB1 b1, ComponentB2 b2 ) {
		this.a1 = a1;
		this.a2 = a2;
		this.b1 = b1;
		this.b2 = b2;
	}

	public ComponentX( ComponentA a, ComponentB b, ComponentA1 a1, ComponentA2 a2, ComponentB1 b1, ComponentB2 b2 ) {
		this.a = a;
		this.b = b;
		this.a1 = a1;
		this.a2 = a2;
		this.b1 = b1;
		this.b2 = b2;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public String toString() {
		return super.toString().substring( super.toString().indexOf( '@' ) + 1 ) + "@" + getClass().getSimpleName() + " [a=" + a + ", a1=" + a1 + ", a2=" + a2 + ", b=" + b + ", b1=" + b1 + ", b2=" + b2 + "]";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
