// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

import static org.junit.jupiter.api.Assertions.*;

import java.lang.reflect.Constructor;

import org.junit.jupiter.api.Test;

public class ReactorTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean( "log.test" );

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testReactor1() throws DependencyException {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class );
		theReactor.addDependency( ComponentA.class );
		theReactor.addDependency( ComponentB.class );
		theReactor.addDependency( ComponentA1.class );
		theReactor.addDependency( ComponentA2.class );
		theReactor.addDependency( ComponentB1.class );
		theReactor.addDependency( ComponentB2.class );
		Dependency<?> theImpl = theX; // Bad, just testing the implementation...
		Constructor<?>[] theResult = theImpl.toSuitableConstructors( theReactor.toDependencies() );
		assertEquals( ComponentA.class, theResult[0].getParameters()[0].getType() );
		assertEquals( ComponentB.class, theResult[0].getParameters()[1].getType() );
		assertEquals( ComponentA1.class, theResult[0].getParameters()[2].getType() );
		assertEquals( ComponentA2.class, theResult[0].getParameters()[3].getType() );
		assertEquals( ComponentB1.class, theResult[0].getParameters()[4].getType() );
		assertEquals( ComponentB2.class, theResult[0].getParameters()[5].getType() );
		assertEquals( 6, theResult[0].getParameters().length );
		assertEquals( ComponentB2.class, theResult[4].getParameters()[0].getType() );
		assertEquals( 1, theResult[4].getParameters().length );
	}

	@Test
	public void testReactor2() throws DependencyException {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class );
		try {
			Dependency<?> theImpl = theX; // Bad, just testing the implementation...
			theImpl.toSuitableConstructors( theReactor.toDependencies() );
		}
		catch ( UnsatisfiedDependencyException e ) {
			if ( IS_LOG_TEST_ENABLED ) {
				System.out.println( "EXPECTED: " + e.getMessage() );
			}
		}
	}

	@Test
	public void testProfiles1() {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class ).withProfiles( "test", "local" );
		boolean hasProfile = theX.hasProfile( "test" );
		assertTrue( hasProfile );
	}

	@Test
	public void testProfiles2() {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class ).withProfiles( "test", "local" );
		boolean hasProfile = theX.hasProfile( "prod" );
		assertFalse( hasProfile );
	}

	@Test
	public void testProfiles3() {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class ).withProfiles( "test", "local" );
		boolean hasProfile = theX.hasProfile( "prod", "test" );
		assertTrue( hasProfile );
	}

	@Test
	public void testProfiles4() {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class ).withProfiles( "test", "local" );
		boolean hasProfile = theX.hasProfile( "prod", "int" );
		assertFalse( hasProfile );
	}

	@Test
	public void testProfiles5() {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class ).withProfiles( "test", "local" );
		boolean hasProfile = theX.hasProfile();
		assertFalse( hasProfile );
	}

	@Test
	public void testProfiles6() {
		Reactor theReactor = new Reactor();
		Dependency<?> theX = theReactor.addDependency( ComponentX.class );
		boolean hasProfile = theX.hasProfile( "test", "local" );
		assertTrue( hasProfile );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
