/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.ClaimsAccessor;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.FactoryClaim;
import org.refcodes.decoupling.InitializerClaim;
import org.refcodes.decoupling.InstanceMetrics;
import org.refcodes.decoupling.InstanceMetricsAccessor;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.ProfilesAccessor;
import org.refcodes.decoupling.TagsAccessor;
import org.refcodes.factory.Factory;
import org.refcodes.factory.Initializer;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.InstanceAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.textual.CaseStyleBuilder;

public class DependencyBuilder<T>
extends Dependency<T>
implements AliasAccessor.AliasProperty,
AliasAccessor.AliasBuilder<DependencyBuilder<T>>,
TypeAccessor.TypeProperty<T>,
TypeAccessor.TypeBuilder<T, DependencyBuilder<T>>,
InstanceAccessor.InstanceProperty<T>,
InstanceAccessor.InstanceBuilder<T, DependencyBuilder<T>>,
ProfilesAccessor.ProfilesProperty,
ProfilesAccessor.ProfilesBuilder<DependencyBuilder<T>>,
TagsAccessor.TagsProperty,
TagsAccessor.TagsBuilder<DependencyBuilder<T>>,
InstanceMetricsAccessor.InstanceMetricsProperty,
InstanceMetricsAccessor.InstanceMetricsBuilder<DependencyBuilder<T>>,
ClaimsAccessor.ClaimsProperty,
ClaimsAccessor.ClaimsBuilder<DependencyBuilder<T>> {
    protected DependencyBuilder() {
    }

    public DependencyBuilder(Class<T> aType) {
        super(aType);
    }

    public DependencyBuilder(T aInstance) {
        super(aInstance);
    }

    public T getInstance() {
        return this._instances.size() != 0 ? (T)this._instances.iterator().next() : null;
    }

    public boolean addClaim(String aAlias) {
        return this._claims.add(new Claim(aAlias));
    }

    public boolean addClaim(Claim aClaim) {
        return this._claims.add(aClaim);
    }

    public boolean addClaim(Class<?> aType) {
        return this._claims.add(new Claim(aType));
    }

    public boolean addClaim(Class<?> aType, String aAlias) {
        return this._claims.add(new Claim(aType, aAlias));
    }

    public boolean addProfile(Object aProfile) {
        return this._profiles.add(aProfile);
    }

    public boolean addTag(Object aTag) {
        return this._tags.add(aTag);
    }

    public <I> void setInitializer(InitializerClaim<I, T> aInitializer) {
        this._initializer = aInitializer;
    }

    public <I> void setInitializer(Class<I> aDependency, BiFunction<T, I, T> aInitializer) {
        this._initializer = new InitializerClaim<I, T>(aDependency, aInitializer);
    }

    public <I> void setInitializer(Class<I> aDependency, BiFunction<T, I, T> aInitializer, String aAlias) {
        this._initializer = new InitializerClaim<I, T>(aDependency, aInitializer, aAlias);
    }

    public <F extends Initializer<T>> void setInitializer(Class<F> aFactory) {
        this.setInitializer(aFactory, (T t, I i) -> i.initialize(t));
    }

    public <F extends Initializer<T>> void setInitializer(Class<F> aFactory, String aAlias) {
        this.setInitializer(aFactory, (t, i) -> i.initialize(t), aAlias);
    }

    public <F> void setFactory(FactoryClaim<F, T> aFactory) {
        this._factory = aFactory;
    }

    public <F> void setFactory(Class<F> aDependency, Function<F, T> aFactory) {
        this._factory = new FactoryClaim<F, T>(aDependency, aFactory);
    }

    public <F> void setFactory(Class<F> aDependency, Function<F, T> aFactory, String aAlias) {
        this._factory = new FactoryClaim<F, T>(aDependency, aFactory, aAlias);
    }

    public <F extends Factory<T>> void setFactory(Class<F> aFactory) {
        this.setFactory(aFactory, Factory::create);
    }

    public <F extends Factory<T>> void setFactory(Class<F> aFactory, String aAlias) {
        this.setFactory(aFactory, Factory::create, aAlias);
    }

    public void setAlias(String aAlias) {
        this._alias = aAlias;
    }

    @Override
    public void setInstance(T aInstance) {
        super.setInstance(aInstance);
    }

    @Override
    public void setInstanceMetrics(InstanceMetrics aInstanceMetrics) {
        this._instanceMetrics = aInstanceMetrics;
    }

    public void setInstanceMetrics(InstanceMode aInstanceMode) {
        this._instanceMetrics = aInstanceMode;
    }

    @Override
    public void setProfiles(Object[] aProfiles) {
        aProfiles = aProfiles != null ? aProfiles : new Object[]{};
        this._profiles = new HashSet<Object>(Arrays.asList(aProfiles));
    }

    public void setProfiles(Collection<?> aProfiles) {
        this._profiles = new HashSet(aProfiles);
    }

    @Override
    public void setTags(Object[] aTags) {
        aTags = aTags != null ? aTags : new Object[]{};
        this._tags = new HashSet<Object>(Arrays.asList(aTags));
    }

    public void setTags(Collection<?> aTags) {
        this._tags = new HashSet(aTags);
    }

    @Override
    public void setClaims(Claim[] aClaims) {
        aClaims = aClaims != null ? aClaims : new Claim[]{};
        this._claims = new HashSet<Claim>(Arrays.asList(aClaims));
    }

    public void setClaims(Collection<Claim> aClaims) {
        this._claims = new HashSet<Claim>(aClaims);
    }

    public void setType(Class<T> aType) {
        if (aType == null) {
            throw new IllegalArgumentException("The provided type must not(!) be null!");
        }
        this._type = aType;
        if (this._alias == null && this._alias.isEmpty()) {
            this._alias = CaseStyleBuilder.asCamelCase((String)this._type.getSimpleName());
        }
    }

    public DependencyBuilder<T> withAddClaim(Claim aClaim) {
        this.addClaim(aClaim);
        return this;
    }

    public DependencyBuilder<T> withAddClaim(String aAlias) {
        this.addClaim(new Claim(aAlias));
        return this;
    }

    public DependencyBuilder<T> withAddClaim(Class<?> aType) {
        this.addClaim(new Claim(aType));
        return this;
    }

    public DependencyBuilder<T> withAddClaim(Class<?> aType, String aAlias) {
        this.addClaim(new Claim(aType, aAlias));
        return this;
    }

    public DependencyBuilder<T> withAddProfile(Object aProfile) {
        this._profiles.add(aProfile);
        return this;
    }

    public DependencyBuilder<T> withAddTag(Object aTag) {
        this._tags.add(aTag);
        return this;
    }

    public DependencyBuilder<T> withAlias(String aAlias) {
        this.setAlias(aAlias);
        return this;
    }

    public DependencyBuilder<T> withInstance(T aInstance) {
        this.setInstance(aInstance);
        return this;
    }

    @Override
    public DependencyBuilder<T> withInstanceMetrics(InstanceMetrics aInstanceMetrics) {
        this.setInstanceMetrics(aInstanceMetrics);
        return this;
    }

    public DependencyBuilder<T> withInstanceMetrics(InstanceMode aInstanceMode) {
        this.setInstanceMetrics(aInstanceMode);
        return this;
    }

    public DependencyBuilder<T> withProfiles(Collection<?> aProfiles) {
        this.setProfiles(aProfiles);
        return this;
    }

    @Override
    public DependencyBuilder<T> withProfiles(Object ... aProfiles) {
        this.setProfiles(aProfiles);
        return this;
    }

    public DependencyBuilder<T> withTags(Collection<?> aTags) {
        this.setTags(aTags);
        return this;
    }

    @Override
    public DependencyBuilder<T> withTags(Object ... aTags) {
        this.setTags(aTags);
        return this;
    }

    public DependencyBuilder<T> withClaims(Collection<Claim> aClaims) {
        this.setClaims(aClaims);
        return this;
    }

    @Override
    public DependencyBuilder<T> withClaims(Claim ... aClaims) {
        this.setClaims(aClaims);
        return this;
    }

    public DependencyBuilder<T> withType(Class<T> aType) {
        this.setType(aType);
        return this;
    }

    public <I> DependencyBuilder<T> withInitializer(InitializerClaim<I, T> aInitializer) {
        this.setInitializer(aInitializer);
        return this;
    }

    public <I> DependencyBuilder<T> withInitializer(Class<I> aDependency, BiFunction<T, I, T> aInitializer) {
        this.setInitializer(aDependency, aInitializer);
        return this;
    }

    public <F> DependencyBuilder<T> withInitializer(Class<F> aDependency, BiFunction<T, F, T> aInitializer, String aAlias) {
        this.setInitializer(aDependency, aInitializer, aAlias);
        return this;
    }

    public <I extends Initializer<T>> DependencyBuilder<T> withInitializer(Class<I> aInitializer) {
        this.setInitializer(aInitializer);
        return this;
    }

    public <I extends Initializer<T>> DependencyBuilder<T> withInitializer(Class<I> aInitializer, String aAlias) {
        this.setInitializer(aInitializer, aAlias);
        return this;
    }

    public <F> DependencyBuilder<T> withFactory(FactoryClaim<F, T> aFactory) {
        this.setFactory(aFactory);
        return this;
    }

    public <F> DependencyBuilder<T> withFactory(Class<F> aDependency, Function<F, T> aFactory) {
        this.setFactory(aDependency, aFactory);
        return this;
    }

    public <F> DependencyBuilder<T> withFactory(Class<F> aDependency, Function<F, T> aFactory, String aAlias) {
        this.setFactory(aDependency, aFactory, aAlias);
        return this;
    }

    public <F extends Factory<T>> DependencyBuilder<T> withFactory(Class<F> aFactory) {
        this.setFactory(aFactory);
        return this;
    }

    public <F extends Factory<T>> DependencyBuilder<T> withFactory(Class<F> aFactory, String aAlias) {
        this.setFactory(aFactory, aAlias);
        return this;
    }
}

