/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.exception;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.refcodes.exception.ExceptionAccessor;

public final class ExceptionUtility {
    private static final String PIPE = "pipe".toLowerCase();
    private static final String SOCKET = "socket".toLowerCase();
    private static final String CLOSED = "closed".toLowerCase();

    private ExceptionUtility() {
    }

    public static String toMessage(Throwable aThrowable) {
        Object theMessage;
        Object theCauseText = "";
        Throwable theRootCause = ExceptionUtility.toRootCause(aThrowable);
        if (theRootCause != null && theRootCause != aThrowable) {
            theCauseText = " Cause <" + theRootCause.getClass().getName() + ">: " + theRootCause.getMessage();
        }
        if (!((theMessage = aThrowable.getMessage()) == null || ((String)theMessage).length() <= 0 || ((String)theMessage).endsWith(".") || ((String)theMessage).endsWith("!") || ((String)theMessage).endsWith("?") || ((String)theMessage).endsWith(":"))) {
            theMessage = (String)theMessage + ".";
        }
        theMessage = theMessage == null || ((String)theMessage).length() == 0 ? "The exception is <" + aThrowable.getClass().getName() + "> without any message" : "Exception <" + aThrowable.getClass().getName() + ">: '" + (String)theMessage + "'";
        return (String)theMessage + (String)theCauseText;
    }

    public static String toStackTrace(Throwable aThrowable) {
        Object eIndent = "";
        String theAppend = ">>";
        StringBuffer theBuffer = new StringBuffer();
        HashSet<Throwable> theThrowables = new HashSet<Throwable>();
        for (Throwable eThrowable = aThrowable; eThrowable != null && !theThrowables.contains(eThrowable); eThrowable = eThrowable.getCause()) {
            theThrowables.add(eThrowable);
            if (aThrowable != eThrowable) {
                theBuffer.append("\n");
            }
            theBuffer.append((String)eIndent + "> Exception <" + eThrowable.getClass().getName() + ">:\n");
            eIndent = (String)eIndent + theAppend;
            for (int i = 0; i < eThrowable.getStackTrace().length; ++i) {
                StackTraceElement eElement = eThrowable.getStackTrace()[i];
                theBuffer.append((String)eIndent + " " + eElement.toString());
                if (i >= eThrowable.getStackTrace().length - 1) continue;
                theBuffer.append("\n");
            }
        }
        return theBuffer.toString();
    }

    public static Throwable toException(Collection<?> aExceptionProperty) {
        ExceptionAccessor eExceptionProperty = null;
        for (Object eObj : aExceptionProperty) {
            if (!(eObj instanceof ExceptionAccessor) || (eExceptionProperty = (ExceptionAccessor)eObj).getException() == null) continue;
            return eExceptionProperty.getException();
        }
        return null;
    }

    public static Throwable toRootCause(Throwable aThrowable) {
        if (aThrowable.getCause() == null) {
            return aThrowable;
        }
        return ExceptionUtility.toRootCause(aThrowable.getCause());
    }

    public static boolean isThrownAsOfAlreadyClosed(IOException aException) {
        if (aException.getMessage().toLowerCase().indexOf(CLOSED) != -1) {
            if (aException.getMessage().toLowerCase().indexOf(SOCKET) != -1) {
                return true;
            }
            if (aException.getMessage().toLowerCase().indexOf(PIPE) != -1) {
                return true;
            }
        }
        return false;
    }
}

