/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.basic.AbstractDifferenceReferringTransform;
import org.revapi.basic.DifferenceMatchRecipe;

public class ClassificationTransform
extends AbstractDifferenceReferringTransform<ClassificationRecipe, Void> {
    public ClassificationTransform() {
        super("revapi", "reclassify");
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return new String[]{"revapi.reclassify"};
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.reclassify".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/classification-schema.json"));
        }
        return null;
    }

    @Override
    @Nullable
    protected Void initConfiguration() {
        return null;
    }

    @Override
    @Nonnull
    protected ClassificationRecipe newRecipe(Void context, ModelNode config) {
        return new ClassificationRecipe(config);
    }

    public void close() {
    }

    public static class ClassificationRecipe
    extends DifferenceMatchRecipe {
        protected final Map<CompatibilityType, DifferenceSeverity> classification = new EnumMap<CompatibilityType, DifferenceSeverity>(CompatibilityType.class);

        public ClassificationRecipe(ModelNode node) {
            super(node);
            ModelNode classfications = node.get("classify");
            for (CompatibilityType ct : CompatibilityType.values()) {
                if (!classfications.has(ct.name())) continue;
                String val = classfications.get(ct.name()).asString();
                DifferenceSeverity sev = DifferenceSeverity.valueOf((String)val);
                this.classification.put(ct, sev);
            }
        }

        @Override
        public Difference transformMatching(Difference difference, Element oldElement, Element newElement) {
            if (this.classification.isEmpty()) {
                return difference;
            }
            return Difference.builder().withCode(difference.code).withName(difference.name).withDescription(difference.description).addAttachments((Iterable)difference.attachments).addClassifications(difference.classification).addClassifications(this.classification).build();
        }
    }
}

