/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.Element;
import org.revapi.basic.DifferenceMatchRecipe;

public abstract class AbstractDifferenceReferringTransform<Recipe extends DifferenceMatchRecipe, ConfigContext>
implements DifferenceTransform<Element> {
    private final String[] propertyPrefix;
    private final String propertyPrefixAsString;
    private Collection<Recipe> configuredRecipes;
    private Pattern[] codes;

    protected AbstractDifferenceReferringTransform(String ... propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
        if (propertyPrefix.length == 0) {
            throw new IllegalArgumentException("The transformation must have a non-empty path in the configuration JSON");
        }
        StringBuilder bld = new StringBuilder(propertyPrefix[0]);
        for (int i = 1; i < propertyPrefix.length; ++i) {
            bld.append(".").append(propertyPrefix[i]);
        }
        this.propertyPrefixAsString = bld.toString();
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nullable
    protected abstract ConfigContext initConfiguration();

    @Nonnull
    protected abstract Recipe newRecipe(@Nullable ConfigContext var1, ModelNode var2) throws IllegalArgumentException;

    public final void initialize(@Nonnull AnalysisContext analysisContext) {
        ConfigContext ctx = this.initConfiguration();
        this.configuredRecipes = new ArrayList<Recipe>();
        int idx = 0;
        ModelNode myNode = analysisContext.getConfiguration().get(this.propertyPrefix);
        if (myNode.getType() != ModelType.LIST) {
            this.codes = new Pattern[0];
            return;
        }
        ArrayList<Pattern> codes = new ArrayList<Pattern>();
        for (ModelNode config : myNode.asList()) {
            try {
                Recipe recipe = this.newRecipe(ctx, config);
                codes.add(((DifferenceMatchRecipe)recipe).codeRegex == null ? Pattern.compile("^" + Pattern.quote(((DifferenceMatchRecipe)recipe).code) + "$") : ((DifferenceMatchRecipe)recipe).codeRegex);
                this.configuredRecipes.add(recipe);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Property " + this.propertyPrefixAsString + "[" + idx + "] is not valid: " + e.getMessage());
            }
        }
        this.codes = codes.toArray(new Pattern[codes.size()]);
    }

    @Nullable
    public final Difference transform(@Nullable Element oldElement, @Nullable Element newElement, @Nonnull Difference difference) {
        if (this.configuredRecipes == null) {
            return difference;
        }
        for (DifferenceMatchRecipe r : this.configuredRecipes) {
            if (!r.matches(difference, oldElement, newElement)) continue;
            return r.transformMatching(difference, oldElement, newElement);
        }
        return difference;
    }
}

