/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.config;

import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.util.ConfigLoader;

public class ServerConfig {
    private final String host;
    private final Integer port;
    private final String username;
    private final String password;

    public ServerConfig() {
        this(null, null, null, null);
    }

    public ServerConfig(String host, Integer port) {
        this(host, port, null, null);
    }

    public ServerConfig(String host, Integer port, String username) {
        this(host, port, username, null);
    }

    public ServerConfig(String host, Integer port, String username, String password) {
        this.host = ConfigLoader.valueOrProperty(host, ConfigLoader.Property.SMTP_HOST);
        this.port = ConfigLoader.valueOrProperty(port, ConfigLoader.Property.SMTP_PORT);
        this.username = ConfigLoader.valueOrProperty(username, ConfigLoader.Property.SMTP_USERNAME);
        this.password = ConfigLoader.valueOrProperty(password, ConfigLoader.Property.SMTP_PASSWORD);
        MiscUtil.checkArgumentNotEmpty(this.host, "smtp host address not given and not configured in config file");
        MiscUtil.checkArgumentNotEmpty(this.port, "smtp host port not given and not configured in config file");
        if (MiscUtil.valueNullOrEmpty(this.username) && !MiscUtil.valueNullOrEmpty(this.password)) {
            throw new IllegalArgumentException("Password provided but no username given as argument or in config file");
        }
    }

    public String toString() {
        String str = String.format("%s:%s", this.host, this.port);
        if (this.username != null) {
            str = str + String.format(", username: %s", this.username);
        }
        if (this.password != null) {
            str = str + " (authenticated)";
        }
        return str;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

