/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5server.msg;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.simplejavamail.mailer.internal.socks.common.SocksException;
import org.simplejavamail.mailer.internal.socks.socks5server.msg.AddressType;
import org.simplejavamail.mailer.internal.socks.socks5server.msg.ServerReply;
import org.simplejavamail.mailer.internal.socks.socks5server.msg.SocksServerReplyException;
import org.simplejavamail.mailer.internal.socks.socks5server.msg.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandMessage.class);
    private InetAddress inetAddress;
    private int port;
    private int command;
    private SocksServerReplyException socksServerReplyException;

    public void read(InputStream inputStream) throws IOException {
        LOGGER.trace("CommandMessage.read");
        StreamUtil.checkEnd(inputStream.read());
        this.command = StreamUtil.checkEnd(inputStream.read());
        StreamUtil.checkEnd(inputStream.read());
        int addressType = StreamUtil.checkEnd(inputStream.read());
        if (!AddressType.isSupport(addressType) && this.socksServerReplyException == null) {
            this.socksServerReplyException = new SocksServerReplyException(ServerReply.ADDRESS_TYPE_NOT_SUPPORTED);
        }
        switch (addressType) {
            case 1: {
                byte[] addressBytes = CommandMessage.read(inputStream, 4);
                this.inetAddress = InetAddress.getByAddress(addressBytes);
                break;
            }
            case 3: {
                int domainLength = StreamUtil.checkEnd(inputStream.read());
                if (domainLength < 1) {
                    throw new SocksException("Length of domain must great than 0");
                }
                byte[] domainBytes = CommandMessage.read(inputStream, domainLength);
                String host = new String(domainBytes, StandardCharsets.UTF_8);
                try {
                    this.inetAddress = InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    if (this.socksServerReplyException != null) break;
                    this.socksServerReplyException = new SocksServerReplyException(ServerReply.HOST_UNREACHABLE);
                }
                break;
            }
        }
        this.port = CommandMessage.bytesToInt(CommandMessage.read(inputStream, 2));
    }

    private static int bytesToInt(byte[] portBytes) {
        if (portBytes.length != 2) {
            throw new IllegalArgumentException("byte array size must be 2");
        }
        return (portBytes[0] & 0xFF) << 8 | portBytes[1] & 0xFF;
    }

    private static byte[] read(InputStream inputStream, int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)StreamUtil.checkEnd(inputStream.read());
        }
        return bytes;
    }

    public boolean hasSocksException() {
        return this.socksServerReplyException != null;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public int getCommand() {
        return this.command;
    }

    public SocksServerReplyException getSocksServerReplyException() {
        return this.socksServerReplyException;
    }
}

