/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.github.client.Configuration;
import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.exception.GithubException;
import org.sourcelab.github.client.exception.InvalidAccessTokenException;
import org.sourcelab.github.client.exception.InvalidPagingRequestException;
import org.sourcelab.github.client.exception.InvalidPermissionsException;
import org.sourcelab.github.client.exception.InvalidRequestException;
import org.sourcelab.github.client.exception.NotFoundException;
import org.sourcelab.github.client.http.Client;
import org.sourcelab.github.client.http.HttpResult;
import org.sourcelab.github.client.objects.AuthenticatedUser;
import org.sourcelab.github.client.request.CancelWorkflowOptions;
import org.sourcelab.github.client.request.CancelWorkflowRequest;
import org.sourcelab.github.client.request.GetAuthenticatedUserRequest;
import org.sourcelab.github.client.request.GetWorkflowJobsForWorkflowRunRequest;
import org.sourcelab.github.client.request.GetWorkflowRunsForWorkflowRequest;
import org.sourcelab.github.client.request.GetWorkflowsForRepositoryRequest;
import org.sourcelab.github.client.request.OctoCatRequest;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.PageableRequest;
import org.sourcelab.github.client.request.Request;
import org.sourcelab.github.client.request.RerunJobFromWorkflowOptions;
import org.sourcelab.github.client.request.RerunJobFromWorkflowRequest;
import org.sourcelab.github.client.request.RerunJobsFromWorkflowOptions;
import org.sourcelab.github.client.request.RerunWorkflowOptions;
import org.sourcelab.github.client.request.RerunWorkflowRequest;
import org.sourcelab.github.client.request.UserReposFilterCriteria;
import org.sourcelab.github.client.request.UserReposRequest;
import org.sourcelab.github.client.request.WorkflowFilterCriteria;
import org.sourcelab.github.client.request.WorkflowJobFilterCriteria;
import org.sourcelab.github.client.request.WorkflowRunFilterCriteria;
import org.sourcelab.github.client.response.ErrorResponse;
import org.sourcelab.github.client.response.PageableResponse;
import org.sourcelab.github.client.response.PagingLinks;
import org.sourcelab.github.client.response.RerunMultipleJobsResponse;
import org.sourcelab.github.client.response.UserReposResponse;
import org.sourcelab.github.client.response.WorkflowJobsResponse;
import org.sourcelab.github.client.response.WorkflowRunsResponse;
import org.sourcelab.github.client.response.WorkflowsForRepositoryResponse;
import org.sourcelab.github.client.response.parser.ErrorResponseParser;

public class GithubClient {
    private static final Logger logger = LoggerFactory.getLogger(GithubClient.class);
    private final Configuration configuration;
    private final Client httpClient;

    public GithubClient(Configuration configuration) {
        this.configuration = configuration;
        this.httpClient = configuration.getClientFactory().createClient(configuration);
    }

    public String octoCat() throws GithubException {
        return this.executeRequest(new OctoCatRequest());
    }

    public AuthenticatedUser getAuthenticatedUser() throws GithubException {
        return this.executeRequest(new GetAuthenticatedUserRequest());
    }

    public UserReposResponse userRepos(UserReposFilterCriteria options) throws GithubException {
        return this.executeRequest(new UserReposRequest(options));
    }

    public WorkflowsForRepositoryResponse getWorkflowsForRepository(WorkflowFilterCriteria options) throws GithubException {
        return this.executeRequest(new GetWorkflowsForRepositoryRequest(options));
    }

    public WorkflowRunsResponse getRunsForWorkflow(WorkflowRunFilterCriteria options) throws GithubException {
        if (options.getWorkflowId() == null) {
            throw new BuilderValidationException("WorkflowId property is required!");
        }
        return this.executeRequest(new GetWorkflowRunsForWorkflowRequest(options));
    }

    public WorkflowRunsResponse getWorkflowRunsForRepository(WorkflowRunFilterCriteria options) throws GithubException {
        return this.executeRequest(new GetWorkflowRunsForWorkflowRequest(options));
    }

    public boolean rerunWorkflow(RerunWorkflowOptions options) throws GithubException {
        return this.executeRequest(new RerunWorkflowRequest(options));
    }

    public boolean cancelWorkflow(CancelWorkflowOptions options) throws GithubException {
        return this.executeRequest(new CancelWorkflowRequest(options));
    }

    public WorkflowJobsResponse getJobsForWorkflowRun(WorkflowJobFilterCriteria options) throws GithubException {
        return this.executeRequest(new GetWorkflowJobsForWorkflowRunRequest(options));
    }

    public boolean rerunJobFromWorkflow(RerunJobFromWorkflowOptions options) throws GithubException {
        return this.executeRequest(new RerunJobFromWorkflowRequest(options));
    }

    public RerunMultipleJobsResponse rerunJobsFromWorkflow(RerunJobsFromWorkflowOptions options) throws GithubException {
        HashMap<Long, Boolean> results = new HashMap<Long, Boolean>();
        for (Long jobId : options.getJobIds()) {
            boolean result = this.executeRequest(new RerunJobFromWorkflowRequest(RerunJobFromWorkflowOptions.newBuilder().withOwner(options.getOwner()).withRepo(options.getRepo()).withJobId(jobId).build()));
            results.put(jobId, result);
        }
        return new RerunMultipleJobsResponse(results);
    }

    public <T> T nextPage(PageableResponse<T> response) throws GithubException {
        PageOptions pageOptions;
        Objects.requireNonNull(response);
        PagingLinks pagingLinks = Objects.requireNonNull(response.getPagingLinks());
        if (!pagingLinks.hasNextUrl()) {
            throw new InvalidPagingRequestException("Requested 'Next' page on response " + response.getClass().getSimpleName() + ", but no Next page is available.");
        }
        try {
            pageOptions = PageOptions.fromUrl(pagingLinks.getNextUrl());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPagingRequestException("Unable to parse URL for paging information", ex);
        }
        PageableRequest<T> request = response.getOriginalRequest();
        request.updatePageOptions(pageOptions);
        return this.executeRequest(request);
    }

    public <T> T executeRequest(Request<T> request) throws GithubException {
        HttpResult result = this.httpClient.executeRequest(request);
        logger.trace("HttpResult: {}", (Object)result);
        if (result.getStatus() != 200 && result.getStatus() != 201 && result.getStatus() != 202 && result.getStatus() != 204) {
            this.handleError(result);
        }
        return request.parseResponse(result);
    }

    private void handleError(HttpResult errorResult) throws GithubException {
        String errorMessage = null;
        List<Object> errors = Collections.emptyList();
        try {
            ErrorResponse errorResponse = new ErrorResponseParser().parseResponse(errorResult);
            errorMessage = errorResponse.getMessage();
            errors = errorResponse.getErrors();
        }
        catch (IOException e) {
            errorMessage = errorResult.getContent();
        }
        if (errorMessage != null && errorMessage.trim().isEmpty()) {
            errorMessage = null;
        }
        switch (errorResult.getStatus()) {
            case 401: {
                throw new InvalidAccessTokenException(errorMessage == null ? "Invalid Access Token" : errorMessage);
            }
            case 403: {
                throw new InvalidPermissionsException(errorMessage == null ? "The resource requested is not available with the access token provided." : errorMessage);
            }
            case 404: {
                throw new NotFoundException(errorMessage == null ? "The URL or Resource Request could not be found" : errorMessage);
            }
            case 422: {
                String validationErrorMessage = errorMessage != null ? errorMessage : "The submitted request was invalid. ";
                validationErrorMessage = validationErrorMessage + "\n" + errors.stream().map(error -> error.getField() + ": " + error.getCode()).collect(Collectors.joining("\n"));
                throw new InvalidRequestException(validationErrorMessage, errors);
            }
        }
        throw new GithubException(errorMessage == null ? "Unknown/Unhandled Error HttpCode: " + errorResult.getStatus() : errorMessage);
    }
}

