/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client;

import java.util.ArrayList;
import java.util.List;
import org.sourcelab.github.client.GithubClient;
import org.sourcelab.github.client.objects.Repository;
import org.sourcelab.github.client.request.Filters;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.UserReposFilterCriteria;
import org.sourcelab.github.client.request.UserReposRequest;
import org.sourcelab.github.client.response.PageableResponse;
import org.sourcelab.github.client.response.UserReposResponse;

public class GithubClientUtils {
    public static <REQUEST, OBJECT> List<OBJECT> retrieveAll(Filters filters, Class<REQUEST> requestClass, Class<OBJECT> objectClass, GithubClient client, int pageLimit) {
        if (!(filters instanceof UserReposFilterCriteria)) {
            throw new RuntimeException("Unknown type.");
        }
        UserReposRequest request = new UserReposRequest((UserReposFilterCriteria)filters);
        ArrayList<Repository> entries = new ArrayList<Repository>();
        boolean hasMore = true;
        int page = 0;
        while (hasMore && page <= pageLimit) {
            request.updatePageOptions(new PageOptions(++page, 100));
            PageableResponse lookupResponse = client.executeRequest(request);
            if (!(filters instanceof UserReposFilterCriteria)) {
                throw new RuntimeException("Unknown type.");
            }
            entries.addAll(((UserReposResponse)lookupResponse).getRepositories());
            hasMore = lookupResponse.getPagingLinks().hasNextUrl();
        }
        ArrayList reversed = new ArrayList(entries);
        return reversed;
    }
}

