/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.http;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourcelab.github.client.http.HttpHeader;

public class HttpHeaders {
    private final Map<String, HttpHeader> headerMap;

    public HttpHeaders(Collection<HttpHeader> headers) {
        Objects.requireNonNull(headers);
        HashMap headerMap = new HashMap();
        headers.forEach(header -> {
            Objects.requireNonNull(header.getName());
            if (headerMap.containsKey(header.getName())) {
                // empty if block
            }
            headerMap.put(header.getName(), header);
        });
        this.headerMap = Collections.unmodifiableMap(headerMap);
    }

    public Set<String> getHeaderNames() {
        return this.headerMap.keySet().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean hasHeader(String name) {
        return this.headerMap.containsKey(name);
    }

    public String getHeader(String name) {
        if (!this.hasHeader(name)) {
            throw new IllegalArgumentException("Header '" + name + "' does not exist.");
        }
        return this.headerMap.get(name).getValue();
    }

    public String toString() {
        return "HttpHeaders{" + this.headerMap + '}';
    }
}

