/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sourcelab.github.client.objects.Actor;
import org.sourcelab.github.client.objects.HeadCommit;
import org.sourcelab.github.client.objects.PullRequest;
import org.sourcelab.github.client.objects.Repository;
import org.sourcelab.github.client.objects.WorkflowRunConclusion;
import org.sourcelab.github.client.objects.WorkflowRunStatus;

public class WorkflowRun {
    private final long id;
    private final String name;
    private final long checkSuiteId;
    private final String headBranch;
    private final String headSha;
    private final long runNumber;
    private final String event;
    private final WorkflowRunStatus status;
    private final WorkflowRunConclusion conclusion;
    private final long workflowId;
    private final String htmlUrl;
    private final String jobsUrl;
    private final String cancelUrl;
    private final String rerunUrl;
    private final long runAttempt;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    private final ZonedDateTime runStartedAt;
    private final HeadCommit headCommit;
    private final Repository repository;
    private final List<PullRequest> pullRequests;
    private final Actor actor;
    private final Actor triggeringActor;

    @JsonCreator
    public WorkflowRun(@JsonProperty(value="id") long id, @JsonProperty(value="name") String name, @JsonProperty(value="check_suite_id") long checkSuiteId, @JsonProperty(value="head_branch") String headBranch, @JsonProperty(value="head_sha") String headSha, @JsonProperty(value="run_number") long runNumber, @JsonProperty(value="event") String event, @JsonProperty(value="status") WorkflowRunStatus status, @JsonProperty(value="conclusion") WorkflowRunConclusion conclusion, @JsonProperty(value="workflow_id") long workflowId, @JsonProperty(value="html_url") String htmlUrl, @JsonProperty(value="jobs_url") String jobsUrl, @JsonProperty(value="cancel_url") String cancelUrl, @JsonProperty(value="rerun_url") String rerunUrl, @JsonProperty(value="run_attempt") long runAttempt, @JsonProperty(value="created_at") ZonedDateTime createdAt, @JsonProperty(value="updated_at") ZonedDateTime updatedAt, @JsonProperty(value="run_started_at") ZonedDateTime runStartedAt, @JsonProperty(value="head_commit") HeadCommit headCommit, @JsonProperty(value="repository") Repository repository, @JsonProperty(value="pull_requests") List<PullRequest> pullRequests, @JsonProperty(value="actor") Actor actor, @JsonProperty(value="triggering_actor") Actor triggeringActor) {
        this.id = id;
        this.name = name;
        this.checkSuiteId = checkSuiteId;
        this.headBranch = headBranch;
        this.headSha = headSha;
        this.runNumber = runNumber;
        this.event = event;
        this.status = status;
        this.conclusion = conclusion;
        this.workflowId = workflowId;
        this.htmlUrl = htmlUrl;
        this.jobsUrl = jobsUrl;
        this.cancelUrl = cancelUrl;
        this.rerunUrl = rerunUrl;
        this.runAttempt = runAttempt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.runStartedAt = runStartedAt;
        this.headCommit = headCommit;
        this.repository = repository;
        this.pullRequests = Collections.unmodifiableList(new ArrayList(pullRequests == null ? Collections.emptyList() : pullRequests));
        this.actor = actor;
        this.triggeringActor = triggeringActor;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEvent() {
        return this.event;
    }

    public long getCheckSuiteId() {
        return this.checkSuiteId;
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public long getRunNumber() {
        return this.runNumber;
    }

    public WorkflowRunStatus getStatus() {
        return this.status;
    }

    public long getWorkflowId() {
        return this.workflowId;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getJobsUrl() {
        return this.jobsUrl;
    }

    public String getCancelUrl() {
        return this.cancelUrl;
    }

    public String getRerunUrl() {
        return this.rerunUrl;
    }

    public long getRunAttempt() {
        return this.runAttempt;
    }

    public ZonedDateTime getRunStartedAt() {
        return this.runStartedAt;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public HeadCommit getHeadCommit() {
        return this.headCommit;
    }

    public WorkflowRunConclusion getConclusion() {
        return this.conclusion;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<PullRequest> getPullRequests() {
        return this.pullRequests;
    }

    public Actor getActor() {
        return this.actor;
    }

    public Actor getTriggeringActor() {
        return this.triggeringActor;
    }

    public String toString() {
        return "WorkflowRun{\n\tid=" + this.id + "\n\tname='" + this.name + '\'' + "\n\tcheckSuiteId=" + this.checkSuiteId + "\n\theadBranch='" + this.headBranch + '\'' + "\n\theadSha='" + this.headSha + '\'' + "\n\trunNumber=" + this.runNumber + "\n\tevent='" + this.event + '\'' + "\n\tstatus=" + (Object)((Object)this.status) + "\n\tconclusion=" + (Object)((Object)this.conclusion) + "\n\tworkflowId=" + this.workflowId + "\n\thtmlUrl='" + this.htmlUrl + '\'' + "\n\tjobsUrl='" + this.jobsUrl + '\'' + "\n\tcancelUrl='" + this.cancelUrl + '\'' + "\n\trerunUrl='" + this.rerunUrl + '\'' + "\n\trunAttempt=" + this.runAttempt + "\n\tcreatedAt=" + this.createdAt + "\n\tupdatedAt=" + this.updatedAt + "\n\trunStartedAt=" + this.runStartedAt + "\n\theadCommit=" + this.headCommit + "\n\trepository=" + this.repository + "\n\tpullRequests=" + this.pullRequests + "\n\tactor=" + this.actor + "\n\ttriggeringActor=" + this.triggeringActor + "\n}";
    }
}

