/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.request.CancelWorkflowOptions;
import org.sourcelab.github.client.utils.UrlParser;

public final class CancelWorkflowOptionsBuilder {
    private String owner = null;
    private String repo = null;
    private Long runId = null;

    public CancelWorkflowOptionsBuilder fromCancelUrl(String cancelUrl) {
        UrlParser.JobsUrlBits bits = null;
        try {
            bits = UrlParser.parseJobsCancelUrl(cancelUrl);
        }
        catch (Exception e) {
            throw new BuilderValidationException("Unable to parse cancelUrl: " + cancelUrl, e);
        }
        if (bits == null) {
            throw new BuilderValidationException("Unable to parse cancelUrl: " + cancelUrl);
        }
        this.withOwner(bits.getOwner()).withRepo(bits.getRepo()).withRunId(bits.getRunId());
        return this;
    }

    public CancelWorkflowOptionsBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public CancelWorkflowOptionsBuilder withRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public CancelWorkflowOptionsBuilder withRunId(long runId) {
        this.runId = runId;
        return this;
    }

    public CancelWorkflowOptions build() {
        if (this.owner == null) {
            throw new BuilderValidationException("owner property is required.");
        }
        if (this.repo == null) {
            throw new BuilderValidationException("repo property is required.");
        }
        if (this.runId == null) {
            throw new BuilderValidationException("runId property is required.");
        }
        return new CancelWorkflowOptions(this.owner, this.repo, this.runId);
    }
}

