/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.Objects;
import org.sourcelab.github.client.request.GetRequest;
import org.sourcelab.github.client.request.RequestParameters;
import org.sourcelab.github.client.request.RequestParametersBuilder;
import org.sourcelab.github.client.request.WorkflowJobFilterCriteria;
import org.sourcelab.github.client.response.WorkflowJobsResponse;
import org.sourcelab.github.client.response.parser.ResponseParser;
import org.sourcelab.github.client.response.parser.WorkflowJobsParser;

public class GetWorkflowJobsForWorkflowRunRequest
extends GetRequest<WorkflowJobsResponse> {
    private final WorkflowJobFilterCriteria options;

    public GetWorkflowJobsForWorkflowRunRequest(WorkflowJobFilterCriteria options) {
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public String getPath() {
        return "/repos/" + this.options.getOwner() + "/" + this.options.getRepo() + "/actions/runs/" + this.options.getRunId() + "/jobs";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        builder.withPageOptions(this.options.getPageOptions());
        if (this.options.getFilter() != null) {
            builder.withParameter("filter", (Object)this.options.getFilter().name());
        }
        return builder.build();
    }

    @Override
    public ResponseParser<WorkflowJobsResponse> getResponseParser() {
        return new WorkflowJobsParser();
    }
}

