/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.Objects;
import org.sourcelab.github.client.request.GetRequest;
import org.sourcelab.github.client.request.RequestParameters;
import org.sourcelab.github.client.request.RequestParametersBuilder;
import org.sourcelab.github.client.request.WorkflowRunFilterCriteria;
import org.sourcelab.github.client.response.WorkflowRunsResponse;
import org.sourcelab.github.client.response.parser.ResponseParser;
import org.sourcelab.github.client.response.parser.WorkflowRunsParser;

public class GetWorkflowRunsForWorkflowRequest
extends GetRequest<WorkflowRunsResponse> {
    private final WorkflowRunFilterCriteria options;

    public GetWorkflowRunsForWorkflowRequest(WorkflowRunFilterCriteria options) {
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public String getPath() {
        if (this.options.getWorkflowId() != null) {
            return "/repos/" + this.options.getOwner() + "/" + this.options.getRepo() + "/actions/workflows/" + this.options.getWorkflowId() + "/runs";
        }
        return "/repos/" + this.options.getOwner() + "/" + this.options.getRepo() + "/actions/runs";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        builder.withPageOptions(this.options.getPageOptions());
        if (this.options.getActor() != null) {
            builder.withParameter("actor", (Object)this.options.getActor());
        }
        if (this.options.getBranch() != null) {
            builder.withParameter("branch", (Object)this.options.getBranch());
        }
        if (this.options.getEvent() != null) {
            builder.withParameter("event", (Object)this.options.getEvent().name());
        }
        if (this.options.getExcludePullRequests() != null) {
            if (this.options.getExcludePullRequests().booleanValue()) {
                builder.withParameter("exclude_pull_requests", (Object)"true");
            } else {
                builder.withParameter("exclude_pull_requests", (Object)"false");
            }
        }
        if (this.options.getCreated() != null) {
            builder.withParameter("created", (Object)this.options.getCreated());
        }
        if (this.options.getCheckSuiteId() != null) {
            builder.withParameter("check_suite_id", (Object)this.options.getCheckSuiteId());
        }
        if (this.options.getHeadSha() != null) {
            builder.withParameter("head_sha", (Object)this.options.getHeadSha());
        }
        if (this.options.getStatus() != null) {
            builder.withParameter("status", (Object)this.options.getStatus().name());
        }
        return builder.build();
    }

    @Override
    public ResponseParser<WorkflowRunsResponse> getResponseParser() {
        return new WorkflowRunsParser(this);
    }
}

