/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.Objects;
import org.sourcelab.github.client.request.GetRequest;
import org.sourcelab.github.client.request.RequestParameters;
import org.sourcelab.github.client.request.RequestParametersBuilder;
import org.sourcelab.github.client.request.WorkflowFilterCriteria;
import org.sourcelab.github.client.response.WorkflowsForRepositoryResponse;
import org.sourcelab.github.client.response.parser.ResponseParser;
import org.sourcelab.github.client.response.parser.WorkflowsForRepositoryParser;

public class GetWorkflowsForRepositoryRequest
extends GetRequest<WorkflowsForRepositoryResponse> {
    private final WorkflowFilterCriteria options;

    public GetWorkflowsForRepositoryRequest(WorkflowFilterCriteria options) {
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public String getPath() {
        return "/repos/" + this.options.getOwner() + "/" + this.options.getRepo() + "/actions/workflows";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        if (this.options.getPageOptions() != null) {
            builder.withParameter("page", (Object)this.options.getPageOptions().getPage());
            builder.withParameter("per_page", (Object)this.options.getPageOptions().getPerPage());
        }
        return builder.build();
    }

    @Override
    public ResponseParser<WorkflowsForRepositoryResponse> getResponseParser() {
        return new WorkflowsForRepositoryParser(this);
    }
}

