/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageOptions {
    private final int page;
    private final int perPage;

    public PageOptions() {
        this(1, 30);
    }

    public PageOptions(int page, int perPage) {
        this.page = page;
        this.perPage = perPage;
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public static PageOptions fromUrl(String url) {
        Matcher pageMatcher;
        Objects.requireNonNull(url);
        Pattern perPagePattern = Pattern.compile(".*[?&]per_page=([0-9]+).*");
        Pattern pagePattern = Pattern.compile(".*[?&]page=([0-9]+).*");
        Integer perPage = null;
        Integer page = null;
        Matcher perPageMatcher = perPagePattern.matcher(url);
        if (perPageMatcher.matches() && perPageMatcher.groupCount() == 1) {
            perPage = Integer.parseInt(perPageMatcher.group(1));
        }
        if ((pageMatcher = pagePattern.matcher(url)).matches() && pageMatcher.groupCount() == 1) {
            page = Integer.parseInt(pageMatcher.group(1));
        }
        if (perPage == null || page == null) {
            throw new IllegalArgumentException("Unable to parse url " + url);
        }
        return new PageOptions(page, perPage);
    }

    public String toString() {
        return "PageOptions{\n\tpage=" + this.page + "\n\tperPage=" + this.perPage + "\n}";
    }
}

