/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.io.IOException;
import java.util.Collections;
import org.sourcelab.github.client.exception.RequestParsingException;
import org.sourcelab.github.client.exception.ResponseParsingException;
import org.sourcelab.github.client.http.HttpResult;
import org.sourcelab.github.client.request.HttpMethod;
import org.sourcelab.github.client.request.RequestParameters;
import org.sourcelab.github.client.response.parser.ResponseParser;

public interface Request<T> {
    public HttpMethod getMethod();

    public String getPath();

    default public RequestParameters getRequestParameters() {
        return new RequestParameters(Collections.emptyList());
    }

    default public String getRequestBody() throws RequestParsingException {
        return null;
    }

    public ResponseParser<T> getResponseParser();

    default public T parseResponse(HttpResult result) {
        try {
            return this.getResponseParser().parseResponse(result);
        }
        catch (IOException parseException) {
            String message = "Unable to parse response from API: " + parseException.getMessage() + "\nResponse From API: \n" + result.getContent();
            throw new ResponseParsingException(message, parseException);
        }
    }
}

