/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.RequestParameter;
import org.sourcelab.github.client.request.RequestParameters;

public class RequestParametersBuilder {
    final Map<String, Set<String>> values = new HashMap<String, Set<String>>();

    public RequestParametersBuilder withParameter(String name, Collection<String> values) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(values);
        values.forEach(value -> this.withParameter(name, value));
        return this;
    }

    public RequestParametersBuilder withParameter(String name, Object value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (!this.values.containsKey(name)) {
            this.values.put(name, new HashSet());
        }
        this.values.get(name).add(value.toString());
        return this;
    }

    public RequestParametersBuilder withParameter(String name, Object ... values) {
        Arrays.asList(values).forEach(value -> this.withParameter(name, value));
        return this;
    }

    public RequestParametersBuilder withPageOptions(PageOptions pageOptions) {
        if (pageOptions != null) {
            this.withParameter("page", (Object)pageOptions.getPage());
            this.withParameter("per_page", (Object)pageOptions.getPerPage());
        }
        return this;
    }

    public RequestParameters build() {
        ArrayList<RequestParameter> params = new ArrayList<RequestParameter>();
        for (Map.Entry<String, Set<String>> param : this.values.entrySet()) {
            params.add(new RequestParameter(param.getKey(), (Collection<String>)param.getValue()));
        }
        return new RequestParameters(params);
    }
}

