/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.request.RerunJobFromWorkflowOptions;
import org.sourcelab.github.client.utils.UrlParser;

public final class RerunJobFromWorkflowOptionsBuilder {
    private String owner = null;
    private String repo = null;
    private Long jobId = null;
    private Boolean enableDebugLogging;

    public RerunJobFromWorkflowOptionsBuilder fromRerunUrl(String rerunUrl) {
        UrlParser.JobsUrlBits bits = null;
        try {
            bits = UrlParser.parseJobsRerunUrl(rerunUrl);
        }
        catch (Exception e) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + rerunUrl, e);
        }
        if (bits == null) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + rerunUrl);
        }
        this.withOwner(bits.getOwner()).withRepo(bits.getRepo()).withJobId(bits.getRunId());
        return this;
    }

    public RerunJobFromWorkflowOptionsBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public RerunJobFromWorkflowOptionsBuilder withRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public RerunJobFromWorkflowOptionsBuilder withJobId(long jobId) {
        this.jobId = jobId;
        return this;
    }

    public RerunJobFromWorkflowOptionsBuilder withEnableDebugLogging(boolean enableDebugLogging) {
        this.enableDebugLogging = enableDebugLogging;
        return this;
    }

    public RerunJobFromWorkflowOptions build() {
        if (this.owner == null) {
            throw new BuilderValidationException("owner property is required.");
        }
        if (this.repo == null) {
            throw new BuilderValidationException("repo property is required.");
        }
        if (this.jobId == null) {
            throw new BuilderValidationException("jobId property is required.");
        }
        return new RerunJobFromWorkflowOptions(this.owner, this.repo, this.jobId, this.enableDebugLogging);
    }
}

