/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourcelab.github.client.request.RerunJobsFromWorkflowOptionsBuilder;

public class RerunJobsFromWorkflowOptions {
    private final String owner;
    private final String repo;
    private final Set<Long> jobIds;
    private final Boolean enableDebugLogging;

    public static RerunJobsFromWorkflowOptionsBuilder newBuilder() {
        return new RerunJobsFromWorkflowOptionsBuilder();
    }

    public RerunJobsFromWorkflowOptions(String owner, String repo, Collection<Long> jobIds, Boolean enableDebugLogging) {
        this.owner = owner;
        this.repo = repo;
        this.jobIds = Collections.unmodifiableSet(new HashSet<Long>(jobIds));
        this.enableDebugLogging = enableDebugLogging;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }

    public List<Long> getJobIds() {
        return new ArrayList<Long>(this.jobIds);
    }

    public Boolean getEnableDebugLogging() {
        return this.enableDebugLogging;
    }

    public String toString() {
        return "RerunJobFromWorkflowOptions{\n\towner='" + this.owner + '\'' + "\n\trepo='" + this.repo + '\'' + "\n\tjobIds=" + this.jobIds + "\n\tenableDebugLogging=" + this.enableDebugLogging + "\n}";
    }
}

