/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.request.RerunJobsFromWorkflowOptions;
import org.sourcelab.github.client.utils.UrlParser;

public final class RerunJobsFromWorkflowOptionsBuilder {
    private String owner = null;
    private String repo = null;
    private Set<Long> jobIds = new HashSet<Long>();
    private Boolean enableDebugLogging;

    public RerunJobsFromWorkflowOptionsBuilder fromRerunUrl(String rerunUrl) {
        UrlParser.JobsUrlBits bits = null;
        try {
            bits = UrlParser.parseJobsRerunUrl(rerunUrl);
        }
        catch (Exception e) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + rerunUrl, e);
        }
        if (bits == null) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + rerunUrl);
        }
        this.withOwner(bits.getOwner()).withRepo(bits.getRepo()).withJobId(bits.getRunId());
        return this;
    }

    public RerunJobsFromWorkflowOptionsBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public RerunJobsFromWorkflowOptionsBuilder withRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public RerunJobsFromWorkflowOptionsBuilder withJobId(long jobId) {
        this.jobIds.add(jobId);
        return this;
    }

    public RerunJobsFromWorkflowOptionsBuilder withJobIds(Collection<Long> jobIds) {
        this.jobIds.addAll(jobIds);
        return this;
    }

    public RerunJobsFromWorkflowOptionsBuilder withEnableDebugLogging(boolean enableDebugLogging) {
        this.enableDebugLogging = enableDebugLogging;
        return this;
    }

    public RerunJobsFromWorkflowOptions build() {
        if (this.owner == null) {
            throw new BuilderValidationException("owner property is required.");
        }
        if (this.repo == null) {
            throw new BuilderValidationException("repo property is required.");
        }
        if (this.jobIds.isEmpty()) {
            throw new BuilderValidationException("jobId property is required.");
        }
        return new RerunJobsFromWorkflowOptions(this.owner, this.repo, this.jobIds, this.enableDebugLogging);
    }
}

