/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.request.RerunWorkflowOptions;
import org.sourcelab.github.client.utils.UrlParser;

public final class RerunWorkflowOptionsBuilder {
    private String owner = null;
    private String repo = null;
    private Long runId = null;
    private Boolean enableDebugLogging;

    public RerunWorkflowOptionsBuilder fromRerunUrl(String rerunUrl) {
        UrlParser.JobsUrlBits bits = null;
        try {
            bits = UrlParser.parseJobsRerunUrl(rerunUrl);
        }
        catch (Exception e) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + rerunUrl, e);
        }
        if (bits == null) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + rerunUrl);
        }
        this.withOwner(bits.getOwner()).withRepo(bits.getRepo()).withRunId(bits.getRunId());
        return this;
    }

    public RerunWorkflowOptionsBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public RerunWorkflowOptionsBuilder withRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public RerunWorkflowOptionsBuilder withRunId(long runId) {
        this.runId = runId;
        return this;
    }

    public RerunWorkflowOptionsBuilder withEnableDebugLogging(boolean enableDebugLogging) {
        this.enableDebugLogging = enableDebugLogging;
        return this;
    }

    public RerunWorkflowOptions build() {
        if (this.owner == null) {
            throw new BuilderValidationException("owner property is required.");
        }
        if (this.repo == null) {
            throw new BuilderValidationException("repo property is required.");
        }
        if (this.runId == null) {
            throw new BuilderValidationException("runId property is required.");
        }
        return new RerunWorkflowOptions(this.owner, this.repo, this.runId, this.enableDebugLogging);
    }
}

