/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.util.Objects;
import org.sourcelab.github.client.request.PostRequest;
import org.sourcelab.github.client.request.RequestParameters;
import org.sourcelab.github.client.request.RequestParametersBuilder;
import org.sourcelab.github.client.request.RerunWorkflowOptions;
import org.sourcelab.github.client.response.parser.Http201ResponseParser;
import org.sourcelab.github.client.response.parser.ResponseParser;

public class RerunWorkflowRequest
extends PostRequest<Boolean> {
    private final RerunWorkflowOptions options;

    public RerunWorkflowRequest(RerunWorkflowOptions options) {
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public String getPath() {
        return "/repos/" + this.options.getOwner() + "/" + this.options.getRepo() + "/actions/runs/" + this.options.getRunId() + "/rerun";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        if (this.options.getEnableDebugLogging() != null) {
            builder.withParameter("enable_debug_logging", (Object)(this.options.getEnableDebugLogging() != false ? "true" : "false"));
        }
        return builder.build();
    }

    @Override
    public ResponseParser<Boolean> getResponseParser() {
        return new Http201ResponseParser();
    }
}

