/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import org.sourcelab.github.client.objects.Affiliations;
import org.sourcelab.github.client.objects.RepositoryType;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.SortDirection;
import org.sourcelab.github.client.request.UserReposFilterCriteria;

public final class UserReposOptionsBuilder {
    private Set<Affiliations> affiliation = new HashSet<Affiliations>();
    private Set<RepositoryType> type = new HashSet<RepositoryType>();
    private UserReposFilterCriteria.Sort sort = null;
    private SortDirection direction = null;
    private PageOptions pageOptions = new PageOptions();
    private ZonedDateTime since = null;
    private ZonedDateTime before = null;

    public UserReposOptionsBuilder withAffiliations(Set<Affiliations> affiliations) {
        this.affiliation.addAll(affiliations);
        return this;
    }

    public UserReposOptionsBuilder withAffiliation(Affiliations affiliation) {
        this.affiliation.add(affiliation);
        return this;
    }

    public UserReposOptionsBuilder withTypes(Set<RepositoryType> type) {
        this.type.addAll(type);
        return this;
    }

    public UserReposOptionsBuilder withType(RepositoryType type) {
        this.type.add(type);
        return this;
    }

    public UserReposOptionsBuilder withSort(UserReposFilterCriteria.Sort sort) {
        this.sort = sort;
        return this;
    }

    public UserReposOptionsBuilder withDirection(SortDirection direction) {
        this.direction = direction;
        return this;
    }

    public UserReposOptionsBuilder withPageOptions(PageOptions pageOptions) {
        this.pageOptions = pageOptions;
        return this;
    }

    public UserReposOptionsBuilder withSince(ZonedDateTime since) {
        this.since = since;
        return this;
    }

    public UserReposOptionsBuilder withBefore(ZonedDateTime before) {
        this.before = before;
        return this;
    }

    public UserReposFilterCriteria build() {
        return new UserReposFilterCriteria(this.affiliation, this.type, this.sort, this.direction, this.pageOptions, this.since, this.before);
    }
}

