/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sourcelab.github.client.request.GetRequest;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.PageableRequest;
import org.sourcelab.github.client.request.RequestParameters;
import org.sourcelab.github.client.request.RequestParametersBuilder;
import org.sourcelab.github.client.request.UserReposFilterCriteria;
import org.sourcelab.github.client.response.UserReposResponse;
import org.sourcelab.github.client.response.parser.ResponseParser;
import org.sourcelab.github.client.response.parser.UserReposResponseParser;

public class UserReposRequest
extends GetRequest<UserReposResponse>
implements PageableRequest<UserReposResponse> {
    private final UserReposFilterCriteria options;
    private PageOptions pageOptions;

    public UserReposRequest(UserReposFilterCriteria options) {
        Objects.requireNonNull(options);
        this.pageOptions = options.getPageOptions() == null ? new PageOptions() : options.getPageOptions();
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public String getPath() {
        return "/user/repos";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        if (this.pageOptions != null) {
            builder.withPageOptions(this.pageOptions);
        }
        if (this.options.getVisibility() != null && !this.options.getVisibility().trim().isEmpty()) {
            builder.withParameter("visibility", (Object)this.options.getVisibility());
        }
        if (!this.options.getAffiliation().isEmpty()) {
            builder.withParameter("affiliation", (Object)this.options.getAffiliation().stream().map(Enum::name).collect(Collectors.joining(",")));
        }
        if (!this.options.getType().isEmpty()) {
            builder.withParameter("type", (Object)this.options.getType().stream().map(Enum::name).collect(Collectors.joining(",")));
        }
        if (this.options.getSort() != null) {
            builder.withParameter("sort", (Object)this.options.getSort().name());
        }
        if (this.options.getSortDirection() != null) {
            builder.withParameter("direction", (Object)this.options.getSortDirection().name());
        }
        if (this.options.getSince() != null) {
            builder.withParameter("since", (Object)this.options.getSince().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (this.options.getBefore() != null) {
            builder.withParameter("before", (Object)this.options.getBefore().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        return builder.build();
    }

    @Override
    public ResponseParser<UserReposResponse> getResponseParser() {
        return new UserReposResponseParser(this);
    }

    @Override
    public void updatePageOptions(PageOptions pageOptions) {
        this.pageOptions = Objects.requireNonNull(pageOptions);
    }
}

