/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.WorkflowJobFilterCriteria;
import org.sourcelab.github.client.utils.UrlParser;

public final class WorkflowJobFilterCriteriaBuilder {
    private String owner = null;
    private String repo = null;
    private Long runId = null;
    private WorkflowJobFilterCriteria.Filter filter = null;
    private PageOptions pageOptions = new PageOptions();

    public WorkflowJobFilterCriteriaBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public WorkflowJobFilterCriteriaBuilder withRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public WorkflowJobFilterCriteriaBuilder withRunId(long runId) {
        this.runId = runId;
        return this;
    }

    public WorkflowJobFilterCriteriaBuilder fromJobsUrl(String jobsUrl) {
        UrlParser.JobsUrlBits bits = null;
        try {
            bits = UrlParser.parseJobsUrl(jobsUrl);
        }
        catch (Exception e) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + jobsUrl, e);
        }
        if (bits == null) {
            throw new BuilderValidationException("Unable to parse jobsUrl: " + jobsUrl);
        }
        this.withOwner(bits.getOwner()).withRepo(bits.getRepo()).withRunId(bits.getRunId());
        return this;
    }

    public WorkflowJobFilterCriteriaBuilder withFilter(WorkflowJobFilterCriteria.Filter filter) {
        this.filter = filter;
        return this;
    }

    public WorkflowJobFilterCriteriaBuilder withPageOptions(PageOptions pageOptions) {
        this.pageOptions = pageOptions;
        return this;
    }

    public WorkflowJobFilterCriteria build() {
        if (this.owner == null) {
            throw new BuilderValidationException("owner property is required.");
        }
        if (this.repo == null) {
            throw new BuilderValidationException("repo property is required.");
        }
        if (this.runId == null) {
            throw new BuilderValidationException("runId property is required.");
        }
        return new WorkflowJobFilterCriteria(this.owner, this.repo, this.runId, this.filter, this.pageOptions);
    }
}

