/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.request;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.sourcelab.github.client.exception.BuilderValidationException;
import org.sourcelab.github.client.objects.WorkflowRunStatus;
import org.sourcelab.github.client.objects.WorkflowTriggerEventType;
import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.request.WorkflowRunFilterCriteria;

public final class WorkflowRunFilterCriteriaBuilder {
    private String owner = null;
    private String repo = null;
    private Long workflowId = null;
    private String actor = null;
    private String branch = null;
    private WorkflowTriggerEventType event = null;
    private WorkflowRunStatus status = null;
    private Boolean excludePullRequests = null;
    private Long checkSuiteId = null;
    private String headSha = null;
    private String created = null;
    private PageOptions pageOptions = new PageOptions();

    public WorkflowRunFilterCriteriaBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withWorkflowId(long workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withActor(String actor) {
        this.actor = actor;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withEvent(WorkflowTriggerEventType event) {
        this.event = event;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withStatus(WorkflowRunStatus status) {
        this.status = status;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withExcludePullRequests(Boolean excludePullRequests) {
        this.excludePullRequests = excludePullRequests;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withCheckSuiteId(Long checkSuiteId) {
        this.checkSuiteId = checkSuiteId;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withHeadSha(String headSha) {
        this.headSha = headSha;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withPageOptions(PageOptions pageOptions) {
        this.pageOptions = pageOptions;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withCreated(String createdSearchStr) {
        this.created = createdSearchStr;
        return this;
    }

    public WorkflowRunFilterCriteriaBuilder withCreatedNewerThan(ZonedDateTime zonedDateTime) {
        return this.withCreated("created:>" + zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    public WorkflowRunFilterCriteriaBuilder withCreatedNewerOrEqualThan(ZonedDateTime zonedDateTime) {
        return this.withCreated("created:>=" + zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    public WorkflowRunFilterCriteria build() {
        if (this.owner == null) {
            throw new BuilderValidationException("owner property must be supplied.");
        }
        if (this.repo == null) {
            throw new BuilderValidationException("repo property must be supplied.");
        }
        return new WorkflowRunFilterCriteria(this.owner, this.repo, this.workflowId, this.actor, this.branch, this.event, this.status, this.excludePullRequests, this.checkSuiteId, this.headSha, this.created, this.pageOptions);
    }
}

