/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.response;

import org.sourcelab.github.client.request.PageOptions;
import org.sourcelab.github.client.response.PagingLinksBuilder;

public class PagingLinks {
    private String prevUrl;
    private String nextUrl;
    private String firstUrl;
    private String lastUrl;

    public static PagingLinksBuilder newBuilder() {
        return new PagingLinksBuilder();
    }

    public PagingLinks(String prevUrl, String nextUrl, String firstUrl, String lastUrl) {
        this.prevUrl = prevUrl;
        this.nextUrl = nextUrl;
        this.firstUrl = firstUrl;
        this.lastUrl = lastUrl;
    }

    public boolean hasFirstUrl() {
        return this.firstUrl != null;
    }

    public boolean hasLastUrl() {
        return this.lastUrl != null;
    }

    public boolean hasNextUrl() {
        return this.nextUrl != null;
    }

    public boolean hasPrevUrl() {
        return this.prevUrl != null;
    }

    public String getPrevUrl() {
        if (!this.hasPrevUrl()) {
            throw new IllegalStateException("Previous Url is not defined.");
        }
        return this.prevUrl;
    }

    public String getNextUrl() {
        if (!this.hasNextUrl()) {
            throw new IllegalStateException("Next Url is not defined.");
        }
        return this.nextUrl;
    }

    public String getFirstUrl() {
        if (!this.hasFirstUrl()) {
            throw new IllegalStateException("First Url is not defined.");
        }
        return this.firstUrl;
    }

    public String getLastUrl() {
        if (!this.hasLastUrl()) {
            throw new IllegalStateException("Last Url is not defined.");
        }
        return this.lastUrl;
    }

    public long getTotalNumberOfEntries() {
        if (!this.hasLastUrl()) {
            throw new IllegalStateException("Last Url is not defined, cannot determine total number of entries.");
        }
        PageOptions pageOptions = PageOptions.fromUrl(this.getLastUrl());
        return (long)pageOptions.getPage() * (long)pageOptions.getPerPage();
    }

    public String toString() {
        return "LinkHeader{prevUrl='" + this.prevUrl + '\'' + ", nextUrl='" + this.nextUrl + '\'' + ", firstUrl='" + this.firstUrl + '\'' + ", lastUrl='" + this.lastUrl + '\'' + '}';
    }
}

