/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.github.client.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlParser {
    private static final Pattern JOBS_URL_PATTERN = Pattern.compile(".*/repos/([^/]+)/([^/]+)/actions/runs/([0-9]+)/jobs");
    private static final Pattern JOBS_CANCEL_URL_PATTERN = Pattern.compile(".*/repos/([^/]+)/([^/]+)/actions/runs/([0-9]+)/cancel");
    private static final Pattern JOBS_RERUN_URL_PATTERN = Pattern.compile(".*/repos/([^/]+)/([^/]+)/actions/runs/([0-9]+)/rerun");

    public static JobsUrlBits parseJobsUrl(String jobsUrl) {
        Matcher matcher = JOBS_URL_PATTERN.matcher(jobsUrl);
        boolean matchFound = matcher.find();
        if (!matchFound || matcher.groupCount() != 3) {
            return null;
        }
        return new JobsUrlBits(matcher.group(1), matcher.group(2), Long.parseLong(matcher.group(3)));
    }

    public static JobsUrlBits parseJobsCancelUrl(String cancelUrl) {
        Matcher matcher = JOBS_CANCEL_URL_PATTERN.matcher(cancelUrl);
        boolean matchFound = matcher.find();
        if (!matchFound || matcher.groupCount() != 3) {
            return null;
        }
        return new JobsUrlBits(matcher.group(1), matcher.group(2), Long.parseLong(matcher.group(3)));
    }

    public static JobsUrlBits parseJobsRerunUrl(String rerunUrl) {
        Matcher matcher = JOBS_RERUN_URL_PATTERN.matcher(rerunUrl);
        boolean matchFound = matcher.find();
        if (!matchFound || matcher.groupCount() != 3) {
            return null;
        }
        return new JobsUrlBits(matcher.group(1), matcher.group(2), Long.parseLong(matcher.group(3)));
    }

    public static class JobsUrlBits {
        private String owner;
        private String repo;
        private long runId;

        public JobsUrlBits(String owner, String repo, long runId) {
            this.owner = owner;
            this.repo = repo;
            this.runId = runId;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getRepo() {
            return this.repo;
        }

        public long getRunId() {
            return this.runId;
        }

        public String toString() {
            return "JobsUrlBits{\n\towner='" + this.owner + '\'' + "\n\trepo='" + this.repo + '\'' + "\n\trunId=" + this.runId + "\n}";
        }
    }
}

