/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.jcs;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.provider.AbstractCacheModelValidator;
import org.springmodules.cache.provider.InvalidCacheModelException;
import org.springmodules.cache.provider.jcs.JcsCachingModel;
import org.springmodules.cache.provider.jcs.JcsFlushingModel;

public final class JcsModelValidator
extends AbstractCacheModelValidator {
    static /* synthetic */ Class class$org$springmodules$cache$provider$jcs$JcsCachingModel;
    static /* synthetic */ Class class$org$springmodules$cache$provider$jcs$JcsFlushingModel;

    protected Class getCachingModelTargetClass() {
        return class$org$springmodules$cache$provider$jcs$JcsCachingModel == null ? (class$org$springmodules$cache$provider$jcs$JcsCachingModel = JcsModelValidator.class$("org.springmodules.cache.provider.jcs.JcsCachingModel")) : class$org$springmodules$cache$provider$jcs$JcsCachingModel;
    }

    protected Class getFlushingModelTargetClass() {
        return class$org$springmodules$cache$provider$jcs$JcsFlushingModel == null ? (class$org$springmodules$cache$provider$jcs$JcsFlushingModel = JcsModelValidator.class$("org.springmodules.cache.provider.jcs.JcsFlushingModel")) : class$org$springmodules$cache$provider$jcs$JcsFlushingModel;
    }

    protected void validateCachingModelProperties(Object cachingModel) throws InvalidCacheModelException {
        JcsCachingModel model = (JcsCachingModel)cachingModel;
        if (!StringUtils.hasText((String)model.getCacheName())) {
            throw new InvalidCacheModelException("Cache name should not be empty");
        }
    }

    protected void validateFlushingModelProperties(Object flushingModel) throws InvalidCacheModelException {
        JcsFlushingModel model = (JcsFlushingModel)flushingModel;
        Object[] structs = model.getCacheStructs();
        if (ObjectUtils.isEmpty((Object[])structs)) {
            throw new InvalidCacheModelException("There should be at least one cache to flush");
        }
        int structCount = structs.length;
        for (int i = 0; i < structCount; ++i) {
            Object struct = structs[i];
            if (StringUtils.hasText((String)((JcsFlushingModel.CacheStruct)struct).getCacheName())) continue;
            throw new InvalidCacheModelException("Cache name should not be empty in the struct with index <" + i + ">");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

