/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.IdentitySetter;

public class HibernateQuery
implements SqlQuery {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    Session session;
    SQLQuery query;
    List<String> identities = new ArrayList<String>();
    Map<String, IdentitySetter> identitySetters = new HashMap<String, IdentitySetter>();
    Map<String, Object> identityTypes = new HashMap<String, Object>();
    boolean logError;

    public HibernateQuery(Session session, SQLQuery query) {
        this.session = session;
        this.query = query;
    }

    public Object getQuery() {
        return this.query;
    }

    public SqlQuery setTimeout(int timeout) {
        this.query.setTimeout(timeout);
        return this;
    }

    public SqlQuery setFirstResult(int firstResult) {
        this.query.setFirstResult(firstResult);
        return this;
    }

    public SqlQuery setMaxResults(int maxResults) {
        this.query.setMaxResults(maxResults);
        return this;
    }

    public SqlQuery setOrdered(boolean ordered) {
        return this;
    }

    public List list() throws SqlProcessorException {
        try {
            return this.query.list();
        }
        catch (HibernateException ex) {
            throw this.newSqlProcessorException(ex, this.query.getQueryString());
        }
    }

    public Object unique() throws SqlProcessorException {
        try {
            return this.query.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.newSqlProcessorException(ex, this.query.getQueryString());
        }
    }

    public int update() throws SqlProcessorException {
        if (this.isSetJDBCIdentity()) {
            throw new UnsupportedOperationException("JDBC identity select (IDSEL_JDBC) not supported in Hibernate stack.");
        }
        try {
            int updated = this.query.executeUpdate();
            if (!this.identities.isEmpty()) {
                String identityName = this.identities.get(0);
                this.doIdentitySelect(identityName);
            }
            return updated;
        }
        catch (HibernateException ex) {
            throw this.newSqlProcessorException(ex, this.query.getQueryString());
        }
    }

    private boolean isSetJDBCIdentity() {
        for (String identityName : this.identities) {
            IdentitySetter identitySetter = this.identitySetters.get(identityName);
            if (!identitySetter.getIdentitySelect().equals("JDBC")) continue;
            return true;
        }
        return false;
    }

    private void doIdentitySelect(String identityName) {
        IdentitySetter identitySetter = this.identitySetters.get(identityName);
        Object identityType = this.identityTypes.get(identityName);
        SQLQuery query2 = this.session.createSQLQuery(identitySetter.getIdentitySelect());
        query2.addScalar("1", (Type)identityType);
        Object identityValue = query2.uniqueResult();
        identitySetter.setIdentity(identityValue);
    }

    public SqlQuery addScalar(String columnAlias) {
        this.query.addScalar(columnAlias);
        return this;
    }

    public SqlQuery addScalar(String columnAlias, Object type) {
        this.query.addScalar(columnAlias, (Type)type);
        return this;
    }

    public SqlQuery setParameter(String name, Object val) throws SqlProcessorException {
        try {
            this.query.setParameter(name, val);
            return this;
        }
        catch (HibernateException ex) {
            throw this.newSqlProcessorException(ex, this.query.getQueryString());
        }
    }

    public SqlQuery setParameter(String name, Object val, Object type) throws SqlProcessorException {
        if (val != null && val instanceof IdentitySetter) {
            this.identities.add(name);
            this.identitySetters.put(name, (IdentitySetter)val);
            this.identityTypes.put(name, type);
        } else {
            try {
                this.query.setParameter(name, val, (Type)type);
            }
            catch (HibernateException ex) {
                throw this.newSqlProcessorException(ex, this.query.getQueryString());
            }
        }
        return this;
    }

    public SqlQuery setParameterList(String name, Object[] vals) throws SqlProcessorException {
        try {
            this.query.setParameterList(name, vals);
            return this;
        }
        catch (HibernateException ex) {
            throw this.newSqlProcessorException(ex, this.query.getQueryString());
        }
    }

    public SqlQuery setParameterList(String name, Object[] vals, Object type) throws SqlProcessorException {
        try {
            this.query.setParameterList(name, vals, (Type)type);
            return this;
        }
        catch (HibernateException ex) {
            throw this.newSqlProcessorException(ex, this.query.getQueryString());
        }
    }

    public List callList() throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public Object callUnique() throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public int callUpdate() throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public Object callFunction() throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch(final String[] statements) throws SqlProcessorException {
        if (statements == null) {
            return null;
        }
        final BatchResultHolder resultHolder = new BatchResultHolder();
        this.session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Statement stmt = null;
                try {
                    stmt = connection.createStatement();
                    for (String statement : statements) {
                        if (statement == null) continue;
                        if (HibernateQuery.this.logger.isDebugEnabled()) {
                            HibernateQuery.this.logger.debug("executeBatch, add " + statement);
                        }
                        stmt.addBatch(statement);
                    }
                    resultHolder.result = stmt.executeBatch();
                }
                catch (SQLException he) {
                    throw new SqlProcessorException((Throwable)he);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException ignore) {}
                    }
                }
            }
        });
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeBatch, result " + SqlUtils.asList((int[])resultHolder.result));
        }
        return resultHolder.result;
    }

    protected SqlProcessorException newSqlProcessorException(HibernateException ex, String query) {
        if (this.logError) {
            this.logger.error("Failed SQL command '" + query + "': " + ex.getMessage());
            return new SqlProcessorException((Throwable)ex);
        }
        return new SqlProcessorException((Throwable)ex, query);
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    static final class BatchResultHolder {
        int[] result;

        BatchResultHolder() {
        }
    }
}

