/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.hibernate;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hibernate.Session;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.hibernate.HibernateQuery;

public class HibernateSession
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Session.class, SqlSession.class};
    private final Session session;

    private HibernateSession(Session session) {
        this.session = session;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            this.session.close();
            return null;
        }
        if ("createSqlQuery".equals(method.getName())) {
            String queryString = (String)args[0];
            return new HibernateQuery(this.session, this.session.createSQLQuery(queryString));
        }
        if ("executeBatch".equals(method.getName())) {
            String[] statements = (String[])args[0];
            HibernateQuery hibernateQuery = new HibernateQuery(this.session, null);
            return hibernateQuery.executeBatch(statements);
        }
        try {
            return method.invoke((Object)this.session, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static SqlSession generateProxy(Session session) {
        HibernateSession handler = new HibernateSession(session);
        return (SqlSession)Proxy.newProxyInstance(HibernateSession.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)handler);
    }

    public static ClassLoader getProxyClassLoader() {
        return SqlSession.class.getClassLoader();
    }
}

