/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClobType;
import org.hibernate.type.DateType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.type.WrapperBinaryType;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.LongTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.BigIntTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.hibernate.type.HibernateTypeFactory;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlMetaType;

public class HibernateDefaultType
extends SqlMetaType {
    static Map<Class<?>, Type> hibernateTypes = new HashMap();

    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        Type hibernateType = hibernateTypes.get(attributeType);
        if (hibernateType != null) {
            query.addScalar(dbName, (Object)hibernateType);
        } else {
            query.addScalar(dbName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Class attributeType;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult DEFAULT: resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
        if ((attributeType = BeanUtils.getFieldType(resultInstance.getClass(), (String)attributeName)) == null) {
            if (!ingoreError) throw new SqlRuntimeException("There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            this.logger.error("There's problem with attribute type for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            return;
        }
        if (attributeType.isEnum()) {
            Method m = BeanUtils.getSetter((Object)resultInstance, (String)attributeName, (Class[])new Class[]{attributeType});
            if (m != null) {
                if (resultValue != null && resultValue instanceof BigDecimal) {
                    resultValue = ((BigDecimal)resultValue).intValue();
                } else if (resultValue != null && resultValue instanceof BigInteger) {
                    resultValue = ((BigInteger)resultValue).intValue();
                }
                Object enumInstance = SqlUtils.getValueToEnum((Class)attributeType, (Object)resultValue);
                BeanUtils.simpleInvokeMethod((Method)m, (Object)resultInstance, (Object)enumInstance);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
                this.logger.error("There's no getter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            }
            return;
        } else {
            Method m = BeanUtils.getSetter((Object)resultInstance, (String)attributeName, (Class[])new Class[]{attributeType});
            if (resultValue != null) {
                if (resultValue instanceof BigDecimal) {
                    resultValue = SqlUtils.convertBigDecimal((Class)attributeType, (Object)resultValue);
                } else if (resultValue instanceof BigInteger) {
                    resultValue = SqlUtils.convertBigInteger((Class)attributeType, (Object)resultValue);
                }
            }
            if (m != null) {
                BeanUtils.simpleInvokeMethod((Method)m, (Object)resultInstance, (Object)resultValue);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
                this.logger.error("There's no getter for '" + attributeName + "' in " + resultInstance + ", META type is DEFAULT");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter DEFAULT: paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (!(inputValue instanceof Collection)) {
            if (inputType.isEnum()) {
                Class clazz = SqlUtils.getEnumToClass(inputType);
                if (clazz == String.class) {
                    HibernateTypeFactory.ENUM_STRING.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else if (clazz == Integer.class) {
                    HibernateTypeFactory.ENUM_INT.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect type based enum " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect type based enum " + inputValue + " for " + paramName);
                }
                return;
            } else {
                SqlMetaType type = SqlProcessContext.getTypeFactory().getMetaType(inputType);
                if (type != null) {
                    type.setParameter(query, paramName, inputValue, inputType, ingoreError);
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect default type " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect default type " + inputValue + " for " + paramName);
                }
            }
            return;
        } else {
            ArrayList<Object> vals = new ArrayList<Object>();
            boolean isEnum = false;
            for (Object val : (Collection)inputValue) {
                if (!val.getClass().isEnum()) break;
                isEnum = true;
                Object o = SqlUtils.getEnumToValue(val);
                if (o != null) {
                    vals.add(o);
                    continue;
                }
                if (!ingoreError) throw new SqlRuntimeException("Incorrect type based enum item value " + o + " for " + paramName);
                this.logger.error("Incorrect type based enum item value " + o + " for " + paramName);
            }
            if (isEnum) {
                query.setParameterList(paramName, vals.toArray());
                return;
            } else {
                query.setParameterList(paramName, ((Collection)inputValue).toArray());
            }
        }
    }

    private Object handleBigDecimal(Class<?> attributeType, Object resultValue) {
        if (resultValue == null || !(resultValue instanceof BigDecimal)) {
            return resultValue;
        }
        BigDecimal result = (BigDecimal)resultValue;
        if (attributeType == Byte.class || attributeType == Byte.TYPE) {
            return result.byteValue();
        }
        if (attributeType == Integer.class || attributeType == Integer.TYPE) {
            return result.intValue();
        }
        if (attributeType == Long.class || attributeType == Long.TYPE) {
            return result.longValue();
        }
        if (attributeType == Short.class || attributeType == Short.TYPE) {
            return result.shortValue();
        }
        return result;
    }

    static {
        hibernateTypes.put(Integer.TYPE, (Type)MyIntegerType.INSTANCE);
        hibernateTypes.put(Integer.class, (Type)MyIntegerType.INSTANCE);
        hibernateTypes.put(Long.TYPE, (Type)MyLongType.INSTANCE);
        hibernateTypes.put(Long.class, (Type)MyLongType.INSTANCE);
        hibernateTypes.put(Short.TYPE, (Type)ShortType.INSTANCE);
        hibernateTypes.put(Short.class, (Type)ShortType.INSTANCE);
        hibernateTypes.put(Byte.TYPE, (Type)ByteType.INSTANCE);
        hibernateTypes.put(Byte.class, (Type)ByteType.INSTANCE);
        hibernateTypes.put(Float.TYPE, (Type)FloatType.INSTANCE);
        hibernateTypes.put(Float.class, (Type)FloatType.INSTANCE);
        hibernateTypes.put(Double.TYPE, (Type)DoubleType.INSTANCE);
        hibernateTypes.put(Double.class, (Type)DoubleType.INSTANCE);
        hibernateTypes.put(Character.TYPE, (Type)CharacterType.INSTANCE);
        hibernateTypes.put(Character.class, (Type)CharacterType.INSTANCE);
        hibernateTypes.put(String.class, (Type)StringType.INSTANCE);
        hibernateTypes.put(java.util.Date.class, (Type)TimestampType.INSTANCE);
        hibernateTypes.put(Timestamp.class, (Type)TimestampType.INSTANCE);
        hibernateTypes.put(Date.class, (Type)DateType.INSTANCE);
        hibernateTypes.put(Time.class, (Type)TimeType.INSTANCE);
        hibernateTypes.put(Boolean.TYPE, (Type)BooleanType.INSTANCE);
        hibernateTypes.put(Boolean.class, (Type)BooleanType.INSTANCE);
        hibernateTypes.put(BigInteger.class, (Type)BigIntegerType.INSTANCE);
        hibernateTypes.put(BigDecimal.class, (Type)BigDecimalType.INSTANCE);
        hibernateTypes.put(byte[].class, (Type)BinaryType.INSTANCE);
        hibernateTypes.put(Byte[].class, (Type)WrapperBinaryType.INSTANCE);
        hibernateTypes.put(Blob.class, (Type)BlobType.INSTANCE);
        hibernateTypes.put(Clob.class, (Type)ClobType.INSTANCE);
    }

    public static class MyLongType
    extends AbstractSingleColumnStandardBasicType<Long>
    implements PrimitiveType<Long>,
    DiscriminatorType<Long>,
    VersionType<Long> {
        public static final MyLongType INSTANCE = new MyLongType();
        private static final Long ZERO = 0L;

        public MyLongType() {
            super((SqlTypeDescriptor)MyBigIntTypeDescriptor.INSTANCE, (JavaTypeDescriptor)LongTypeDescriptor.INSTANCE);
        }

        public String getName() {
            return "long";
        }

        public String[] getRegistrationKeys() {
            return new String[]{this.getName(), Long.TYPE.getName(), Long.class.getName()};
        }

        public Serializable getDefaultValue() {
            return ZERO;
        }

        public Class getPrimitiveClass() {
            return Long.TYPE;
        }

        public Long stringToObject(String xml) throws Exception {
            return new Long(xml);
        }

        public Long next(Long current, SessionImplementor session) {
            return current + 1L;
        }

        public Long seed(SessionImplementor session) {
            return ZERO;
        }

        public Comparator<Long> getComparator() {
            return this.getJavaTypeDescriptor().getComparator();
        }

        public String objectToSQLString(Long value, Dialect dialect) throws Exception {
            return value.toString();
        }
    }

    public static class MyBigIntTypeDescriptor
    extends BigIntTypeDescriptor {
        public static final MyBigIntTypeDescriptor INSTANCE = new MyBigIntTypeDescriptor();

        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

                protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    if (Character.isDigit(name.charAt(0))) {
                        return javaTypeDescriptor.wrap((Object)rs.getLong(Integer.parseInt(name)), options);
                    }
                    return javaTypeDescriptor.wrap((Object)rs.getLong(name), options);
                }
            };
        }
    }

    public static class MyIntegerType
    extends AbstractSingleColumnStandardBasicType<Integer>
    implements PrimitiveType<Integer>,
    DiscriminatorType<Integer>,
    VersionType<Integer> {
        public static final MyIntegerType INSTANCE = new MyIntegerType();
        public static final Integer ZERO = 0;

        public MyIntegerType() {
            super((SqlTypeDescriptor)MyIntegerTypeDescriptor.INSTANCE, (JavaTypeDescriptor)IntegerTypeDescriptor.INSTANCE);
        }

        public String getName() {
            return "integer";
        }

        public String[] getRegistrationKeys() {
            return new String[]{this.getName(), Integer.TYPE.getName(), Integer.class.getName()};
        }

        public Serializable getDefaultValue() {
            return ZERO;
        }

        public Class getPrimitiveClass() {
            return Integer.TYPE;
        }

        public String objectToSQLString(Integer value, Dialect dialect) throws Exception {
            return this.toString(value);
        }

        public Integer stringToObject(String xml) {
            return (Integer)this.fromString(xml);
        }

        public Integer seed(SessionImplementor session) {
            return ZERO;
        }

        public Integer next(Integer current, SessionImplementor session) {
            return current + 1;
        }

        public Comparator<Integer> getComparator() {
            return this.getJavaTypeDescriptor().getComparator();
        }
    }

    public static class MyIntegerTypeDescriptor
    extends org.hibernate.type.descriptor.sql.IntegerTypeDescriptor {
        public static final MyIntegerTypeDescriptor INSTANCE = new MyIntegerTypeDescriptor();

        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

                protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    if (Character.isDigit(name.charAt(0))) {
                        return javaTypeDescriptor.wrap((Object)rs.getInt(Integer.parseInt(name)), options);
                    }
                    return javaTypeDescriptor.wrap((Object)rs.getInt(name), options);
                }
            };
        }
    }
}

