/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.hibernate.type;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.type.SqlMetaType;

public class HibernateType
extends SqlMetaType {
    protected static final Logger logger;
    static Map<String, Field> hibernateTypes;
    private Type hibernateType;

    public HibernateType(String sMetaType) {
        String sHibernateType = sMetaType.toUpperCase();
        Field f = hibernateTypes.get(sHibernateType);
        if (f != null) {
            try {
                this.hibernateType = (Type)f.get(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new SqlRuntimeException("Unsupported Hibernate Type " + sHibernateType);
        }
    }

    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        query.addScalar(dbName, (Object)this.hibernateType);
    }

    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (logger.isTraceEnabled()) {
            logger.trace(">>> setResult HIBERNATE: resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null) + ", hibernateType=" + this.hibernateType);
        }
        if ((m = BeanUtils.getSetter((Object)resultInstance, (String)attributeName, (Class[])new Class[]{this.hibernateType.getReturnedClass()})) == null && this.hibernateType instanceof PrimitiveType) {
            m = BeanUtils.getSetter((Object)resultInstance, (String)attributeName, (Class[])new Class[]{((PrimitiveType)this.hibernateType).getPrimitiveClass()});
        }
        if (m == null && this.hibernateType.getReturnedClass() == Date.class) {
            m = BeanUtils.getSetter((Object)resultInstance, (String)attributeName, (Class[])new Class[]{Timestamp.class});
        }
        if (m != null) {
            BeanUtils.simpleInvokeMethod((Method)m, (Object)resultInstance, (Object)resultValue);
        } else if (ingoreError) {
            logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is HIBERNATE");
        } else {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is HIBERNATE");
        }
    }

    public void setParameter(SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (logger.isTraceEnabled()) {
            logger.trace(">>> setParameter HIBERNATE: paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType + ", hibernateType=" + this.hibernateType);
        }
        if (inputValue instanceof Collection) {
            query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Object)this.hibernateType);
        } else {
            query.setParameter(paramName, inputValue, (Object)this.hibernateType);
        }
    }

    static {
        Field[] fields;
        logger = LoggerFactory.getLogger(HibernateType.class);
        hibernateTypes = new HashMap<String, Field>();
        for (Field f : fields = StandardBasicTypes.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                if (!(f.get(null) instanceof Type)) continue;
                hibernateTypes.put(f.getName().toUpperCase(), f);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

