/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.hibernate.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.hibernate.type.HibernateBigDecimalType;
import org.sqlproc.engine.hibernate.type.HibernateBigIntegerType;
import org.sqlproc.engine.hibernate.type.HibernateBlobType;
import org.sqlproc.engine.hibernate.type.HibernateBooleanType;
import org.sqlproc.engine.hibernate.type.HibernateByteArrayType;
import org.sqlproc.engine.hibernate.type.HibernateByteType;
import org.sqlproc.engine.hibernate.type.HibernateCharType;
import org.sqlproc.engine.hibernate.type.HibernateClobType;
import org.sqlproc.engine.hibernate.type.HibernateDateTimeType;
import org.sqlproc.engine.hibernate.type.HibernateDateType;
import org.sqlproc.engine.hibernate.type.HibernateDefaultType;
import org.sqlproc.engine.hibernate.type.HibernateDoubleType;
import org.sqlproc.engine.hibernate.type.HibernateEnumIntegerType;
import org.sqlproc.engine.hibernate.type.HibernateEnumStringType;
import org.sqlproc.engine.hibernate.type.HibernateFloatType;
import org.sqlproc.engine.hibernate.type.HibernateFromDateType;
import org.sqlproc.engine.hibernate.type.HibernateIdentityType;
import org.sqlproc.engine.hibernate.type.HibernateIntegerType;
import org.sqlproc.engine.hibernate.type.HibernateLongType;
import org.sqlproc.engine.hibernate.type.HibernateShortType;
import org.sqlproc.engine.hibernate.type.HibernateStringType;
import org.sqlproc.engine.hibernate.type.HibernateTextType;
import org.sqlproc.engine.hibernate.type.HibernateTimeType;
import org.sqlproc.engine.hibernate.type.HibernateTimestampType;
import org.sqlproc.engine.hibernate.type.HibernateToDateType;
import org.sqlproc.engine.hibernate.type.HibernateType;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlMetaType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class HibernateTypeFactory
implements SqlTypeFactory {
    private static HibernateTypeFactory factory = new HibernateTypeFactory();
    static final SqlMetaType DEFAULT = new HibernateDefaultType();
    static final SqlMetaType ENUM_INT = new HibernateEnumIntegerType();
    static final SqlMetaType ENUM_STRING = new HibernateEnumStringType();
    static final SqlMetaType IDENTITY = new HibernateIdentityType();
    static final SqlMetaType[] TYPES = new SqlMetaType[]{new HibernateBigDecimalType(), new HibernateBigIntegerType(), new HibernateBooleanType(), new HibernateByteArrayType(), new HibernateByteType(), new HibernateCharType(), new HibernateDateTimeType(), new HibernateDateType(), new HibernateDoubleType(), ENUM_INT, ENUM_STRING, new HibernateFloatType(), new HibernateFromDateType(), new HibernateIntegerType(), new HibernateLongType(), new HibernateShortType(), new HibernateStringType(), new HibernateTimestampType(), new HibernateTimeType(), new HibernateToDateType(), new HibernateTextType(), new HibernateBlobType(), new HibernateClobType()};
    static Map<Class<?>, SqlMetaType> CLASS_TO_TYPE_MAP = new HashMap();
    static Map<String, SqlMetaType> META_TO_TYPE_MAP = new HashMap<String, SqlMetaType>();

    private HibernateTypeFactory() {
    }

    public static HibernateTypeFactory getInstance() {
        return factory;
    }

    public SqlMetaType getDefaultType() {
        return DEFAULT;
    }

    public SqlMetaType getEnumIntegerType() {
        return ENUM_INT;
    }

    public SqlMetaType getEnumStringType() {
        return ENUM_STRING;
    }

    public SqlMetaType getIdentityType() {
        return IDENTITY;
    }

    public SqlMetaType[] getAllTypes() {
        return TYPES;
    }

    public SqlMetaType getMetaType(Class<?> clazz) {
        return CLASS_TO_TYPE_MAP.get(clazz);
    }

    public SqlMetaType getMetaType(String name) {
        if (name.startsWith("h_")) {
            return new HibernateType(name.substring(2));
        }
        SqlMetaType metaType = META_TO_TYPE_MAP.get(name.toUpperCase());
        if (metaType == null) {
            throw new SqlRuntimeException("Unsupported Meta Type " + name);
        }
        return metaType;
    }

    static {
        for (SqlMetaType type : TYPES) {
            if (!(type instanceof SqlInternalType)) continue;
            for (Class classType : ((SqlInternalType)type).getClassTypes()) {
                CLASS_TO_TYPE_MAP.put(classType, type);
            }
            for (String metaType : ((SqlInternalType)type).getMetaTypes()) {
                META_TO_TYPE_MAP.put(metaType.toUpperCase(), type);
            }
        }
        CLASS_TO_TYPE_MAP = Collections.unmodifiableMap(CLASS_TO_TYPE_MAP);
        META_TO_TYPE_MAP = Collections.unmodifiableMap(META_TO_TYPE_MAP);
    }
}

