// $ANTLR 3.3 Nov 30, 2010 12:46:29 org/sqlproc/engine/impl/SqlProcessor.g 2011-05-28 16:34:25
 
package org.sqlproc.engine.impl;

import java.util.Map;
import java.util.Set;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.type.SqlMetaType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class SqlProcessorParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "WS", "IDENT", "LPAREN", "STATEMENT", "COMMA", "RPAREN", "EQUALS", "SEMICOLON", "MAPPING", "OPTION", "COLON", "STRING", "AT", "LBRACE", "RBRACE", "QUESTI", "BAND", "BOR", "HASH", "NUMBER", "AND", "OR", "NOT", "IDENT_DOT", "CARET", "PLUS", "MINUS", "LESS_THAN", "MORE_THAN", "DOT", "DIGIT", "ESC_COLON", "ESC_SEMICOLON", "ESC_STRING", "ESC_LBRACE", "ESC_RBRACE", "ESC_BOR", "ESC_HASH", "ESC_AT", "ESC_CHAR", "REST"
    };
    public static final int EOF=-1;
    public static final int WS=4;
    public static final int IDENT=5;
    public static final int LPAREN=6;
    public static final int STATEMENT=7;
    public static final int COMMA=8;
    public static final int RPAREN=9;
    public static final int EQUALS=10;
    public static final int SEMICOLON=11;
    public static final int MAPPING=12;
    public static final int OPTION=13;
    public static final int COLON=14;
    public static final int STRING=15;
    public static final int AT=16;
    public static final int LBRACE=17;
    public static final int RBRACE=18;
    public static final int QUESTI=19;
    public static final int BAND=20;
    public static final int BOR=21;
    public static final int HASH=22;
    public static final int NUMBER=23;
    public static final int AND=24;
    public static final int OR=25;
    public static final int NOT=26;
    public static final int IDENT_DOT=27;
    public static final int CARET=28;
    public static final int PLUS=29;
    public static final int MINUS=30;
    public static final int LESS_THAN=31;
    public static final int MORE_THAN=32;
    public static final int DOT=33;
    public static final int DIGIT=34;
    public static final int ESC_COLON=35;
    public static final int ESC_SEMICOLON=36;
    public static final int ESC_STRING=37;
    public static final int ESC_LBRACE=38;
    public static final int ESC_RBRACE=39;
    public static final int ESC_BOR=40;
    public static final int ESC_HASH=41;
    public static final int ESC_AT=42;
    public static final int ESC_CHAR=43;
    public static final int REST=44;

    // delegates
    // delegators


        public SqlProcessorParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public SqlProcessorParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return SqlProcessorParser.tokenNames; }
    public String getGrammarFileName() { return "org/sqlproc/engine/impl/SqlProcessor.g"; }


      private Token getLastToken() {
        return input.LT(-1);
      }

      private Stack artifactName = new Stack();
      private Stack partialErrors = new Stack();
      private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
      
      public List<ErrorMsg> getErrors() {
        return errors;
      }

      @Override
      public void reportError(RecognitionException e) {
        String msg = super.getErrorMessage(e,tokenNames);
        if ( artifactName.size()>0 ) {
          String name = (String)artifactName.peek();
          partialErrors.push(ParserUtils.create(name,msg,e,tokenNames));
        }
        else {
          errors.add(ParserUtils.create(null,msg,e,tokenNames));
        }
      }
      
      String getText(Token token) {
        if (token == null)
          return null;
        return token.getText();
      }
      
      void add(StringBuilder text) {
        int type = getLastToken().getType();
        if (type == ESC_CHAR) {
          text.append(getLastToken().getText().substring(1));
        } 
        else if (type == WS) {
          String s = getLastToken().getText();
          for (int i = 0, l = s.length(); i < l; i++) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\r')
              continue;
            text.append(c);
          }
        } 
        else {
          text.append(getLastToken().getText());
        }
      }
      
      void addText(Object target, StringBuilder text) {
        ParserUtils.addText(target, text);
      }
      
      void addColumn(Object target, SqlMappingItem col, StringBuilder text) {
        ParserUtils.addColumn(target, col, text);
      }
      
      SqlMappingItem newColumn(Token col) {
        return ParserUtils.newColumn(col.getText());
      }
      
      void addColumnAttr(SqlMappingItem item, Token col) {
        ParserUtils.addColumnAttr(item, col.getText());
      }
      
      void addIdent(Object target, SqlMetaIdent ident, StringBuilder text) {
        ParserUtils.addIdent(target, ident, text);
      }
      
      SqlMetaIdent newIdent(Token ident, Token modeIdent, Token caseIdent) {
        return ParserUtils.newIdent(ident.getText(), getText(modeIdent), getText(caseIdent));
      }
      
      void addConstant(Object target, SqlMetaConst cnst, StringBuilder text) {
        ParserUtils.addConstant(target, cnst, text);
      }
      
      SqlMetaConst newConstant(Token cnst, Token caseConversion) {
        return ParserUtils.newConstant(cnst.getText(), getText(caseConversion));
      }
      
      void addOperator(SqlMetaLogExpr expr, boolean isAnd) {
        if (isAnd)
          expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.AND));
        else
          expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.OR));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMappingItem item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMetaIdent item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMetaConst item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }
      
      boolean doSkip(Set<String> onlyStatements, String name) {
        if (onlyStatements == null || onlyStatements.isEmpty())
          return false;
        return !onlyStatements.contains(name);
      }
      
      List<ErrorMsg> getPartialErrors() {
        if (partialErrors.size()==0)
          return null;
        List<ErrorMsg> errorsList = new ArrayList<ErrorMsg>();
        while ( partialErrors.size()>0 ) {
          ErrorMsg errorMsg = (ErrorMsg) partialErrors.pop(); 
          errorsList.add(errorMsg);
        }
        return errorsList;
      }
      
      boolean add(SqlProcessor processor, String type, String name, SqlMetaStatement statement, List<String> activeFilters, String... filters) {
        List<ErrorMsg> errorsList = getPartialErrors();
        processor.addMetaStatement(type, name, statement, errorsList, activeFilters, filters);
        return errorsList == null;
      }
      
      boolean add(SqlProcessor processor, String type, String name, SqlMappingRule mapping, List<String> activeFilters, String... filters) {
        List<ErrorMsg> errorsList = getPartialErrors();
        processor.addMappingRule(type, name, mapping, errorsList, activeFilters, filters);
        return errorsList == null;
      }
      
      boolean add(SqlProcessor processor, String type, String name, String feature, List<String> activeFilters, String... filters) {
        List<ErrorMsg> errorsList = getPartialErrors();
        processor.addFeature(type, name, feature, errorsList, activeFilters, filters);
        return errorsList == null;
      }



    // $ANTLR start "parse"
    // org/sqlproc/engine/impl/SqlProcessor.g:171:1: parse[SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters] returns [SqlProcessor processor] : ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF ;
    public final SqlProcessor parse(SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters) throws RecognitionException {
        SqlProcessor processor = null;

        Token name=null;
        Token type=null;
        Token filter=null;
        SqlMetaStatement metaStatement = null;

        SqlMappingRule mappingRule = null;

        StringBuilder text = null;


        processor = new SqlProcessor(defaultFeatures, onlyStatements); boolean skip; List<String> activeFilters;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:173:9: ( ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF )
            // org/sqlproc/engine/impl/SqlProcessor.g:174:9: ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:174:9: ( WS )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:174:9: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_parse73); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:174:13: ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+
            int cnt8=0;
            loop8:
            do {
                int alt8=4;
                switch ( input.LA(1) ) {
                case IDENT:
                    {
                    switch ( input.LA(2) ) {
                    case LPAREN:
                        {
                        switch ( input.LA(3) ) {
                        case OPTION:
                            {
                            alt8=3;
                            }
                            break;
                        case STATEMENT:
                            {
                            alt8=1;
                            }
                            break;
                        case MAPPING:
                            {
                            alt8=2;
                            }
                            break;

                        }

                        }
                        break;

                    }

                    }
                    break;

                }

                switch (alt8) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:175:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:175:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    // org/sqlproc/engine/impl/SqlProcessor.g:175:11: name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )*
            	    {
            	    name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse90); 
            	    skip=doSkip(onlyStatements,(name!=null?name.getText():null));
            	    match(input,LPAREN,FOLLOW_LPAREN_in_parse94); 
            	    type=(Token)match(input,STATEMENT,FOLLOW_STATEMENT_in_parse98); 
            	    activeFilters = new ArrayList<String>();
            	    // org/sqlproc/engine/impl/SqlProcessor.g:175:129: ( COMMA filter= IDENT )*
            	    loop2:
            	    do {
            	        int alt2=2;
            	        switch ( input.LA(1) ) {
            	        case COMMA:
            	            {
            	            alt2=1;
            	            }
            	            break;

            	        }

            	        switch (alt2) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:175:130: COMMA filter= IDENT
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_parse103); 
            	    	    filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse107); 
            	    	    activeFilters.add((filter!=null?filter.getText():null));

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop2;
            	        }
            	    } while (true);

            	    match(input,RPAREN,FOLLOW_RPAREN_in_parse113); 
            	    match(input,EQUALS,FOLLOW_EQUALS_in_parse115); 
            	    pushFollow(FOLLOW_meta_in_parse131);
            	    metaStatement=meta((name!=null?name.getText():null), _typeFactory, skip);

            	    state._fsp--;

            	    add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), metaStatement, activeFilters, filters);
            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse136); 
            	    // org/sqlproc/engine/impl/SqlProcessor.g:176:154: ( WS )*
            	    loop3:
            	    do {
            	        int alt3=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt3=1;
            	            }
            	            break;

            	        }

            	        switch (alt3) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:176:154: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_parse138); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop3;
            	        }
            	    } while (true);


            	    }


            	    }
            	    break;
            	case 2 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:177:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:177:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    // org/sqlproc/engine/impl/SqlProcessor.g:177:13: name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )*
            	    {
            	    name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse156); 
            	    skip=doSkip(onlyStatements,(name!=null?name.getText():null));
            	    match(input,LPAREN,FOLLOW_LPAREN_in_parse160); 
            	    type=(Token)match(input,MAPPING,FOLLOW_MAPPING_in_parse164); 
            	    activeFilters = new ArrayList<String>();
            	    // org/sqlproc/engine/impl/SqlProcessor.g:177:129: ( COMMA filter= IDENT )*
            	    loop4:
            	    do {
            	        int alt4=2;
            	        switch ( input.LA(1) ) {
            	        case COMMA:
            	            {
            	            alt4=1;
            	            }
            	            break;

            	        }

            	        switch (alt4) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:177:130: COMMA filter= IDENT
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_parse169); 
            	    	    filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse173); 
            	    	    activeFilters.add((filter!=null?filter.getText():null));

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop4;
            	        }
            	    } while (true);

            	    match(input,RPAREN,FOLLOW_RPAREN_in_parse179); 
            	    match(input,EQUALS,FOLLOW_EQUALS_in_parse181); 
            	    pushFollow(FOLLOW_mapping_in_parse197);
            	    mappingRule=mapping((name!=null?name.getText():null), _typeFactory, skip);

            	    state._fsp--;

            	    add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), mappingRule, activeFilters, filters);
            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse202); 
            	    // org/sqlproc/engine/impl/SqlProcessor.g:178:153: ( WS )*
            	    loop5:
            	    do {
            	        int alt5=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt5=1;
            	            }
            	            break;

            	        }

            	        switch (alt5) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:178:153: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_parse204); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop5;
            	        }
            	    } while (true);


            	    }


            	    }
            	    break;
            	case 3 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:179:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:179:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
            	    // org/sqlproc/engine/impl/SqlProcessor.g:179:13: name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )*
            	    {
            	    name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse222); 
            	    match(input,LPAREN,FOLLOW_LPAREN_in_parse224); 
            	    type=(Token)match(input,OPTION,FOLLOW_OPTION_in_parse228); 
            	    activeFilters = new ArrayList<String>();
            	    // org/sqlproc/engine/impl/SqlProcessor.g:179:86: ( COMMA filter= IDENT )*
            	    loop6:
            	    do {
            	        int alt6=2;
            	        switch ( input.LA(1) ) {
            	        case COMMA:
            	            {
            	            alt6=1;
            	            }
            	            break;

            	        }

            	        switch (alt6) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:179:87: COMMA filter= IDENT
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_parse233); 
            	    	    filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse237); 
            	    	    activeFilters.add((filter!=null?filter.getText():null));

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop6;
            	        }
            	    } while (true);

            	    match(input,RPAREN,FOLLOW_RPAREN_in_parse243); 
            	    match(input,EQUALS,FOLLOW_EQUALS_in_parse245); 
            	    pushFollow(FOLLOW_option_in_parse261);
            	    text=option((name!=null?name.getText():null));

            	    state._fsp--;

            	    add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), text.toString(), activeFilters, filters);
            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse266); 
            	    // org/sqlproc/engine/impl/SqlProcessor.g:180:129: ( WS )*
            	    loop7:
            	    do {
            	        int alt7=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt7=1;
            	            }
            	            break;

            	        }

            	        switch (alt7) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:180:129: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_parse268); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop7;
            	        }
            	    } while (true);


            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt8 >= 1 ) break loop8;
                        EarlyExitException eee =
                            new EarlyExitException(8, input);
                        throw eee;
                }
                cnt8++;
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_parse283); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return processor;
    }
    // $ANTLR end "parse"

    protected static class meta_scope {
        StringBuilder text;
        boolean hasOutputMapping;
        SqlTypeFactory typeFactory;
        boolean skip;
    }
    protected Stack meta_stack = new Stack();


    // $ANTLR start "meta"
    // org/sqlproc/engine/impl/SqlProcessor.g:184:1: meta[String name, SqlTypeFactory _typeFactory, boolean _skip] returns [SqlMetaStatement metaStatement] : sql[metaStatement] ( EOF )? ;
    public final SqlMetaStatement meta(String name, SqlTypeFactory _typeFactory, boolean _skip) throws RecognitionException {
        meta_stack.push(new meta_scope());
        SqlMetaStatement metaStatement = null;

        artifactName.push(name); metaStatement = new SqlMetaStatement(); ((meta_scope)meta_stack.peek()).text = new StringBuilder(); ((meta_scope)meta_stack.peek()).typeFactory =_typeFactory; ((meta_scope)meta_stack.peek()).skip =_skip;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:188:2: ( sql[metaStatement] ( EOF )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:188:4: sql[metaStatement] ( EOF )?
            {
            pushFollow(FOLLOW_sql_in_meta315);
            sql(metaStatement);

            state._fsp--;

            // org/sqlproc/engine/impl/SqlProcessor.g:188:23: ( EOF )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case EOF:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:188:23: EOF
                    {
                    match(input,EOF,FOLLOW_EOF_in_meta318); 

                    }
                    break;

            }


            }

            metaStatement.setHasOutputMapping(((meta_scope)meta_stack.peek()).hasOutputMapping); artifactName.pop();
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            meta_stack.pop();
        }
        return metaStatement;
    }
    // $ANTLR end "meta"


    // $ANTLR start "sql"
    // org/sqlproc/engine/impl/SqlProcessor.g:191:1: sql[SqlMetaStatement metaStatement] : (~ ( COLON | STRING | AT | LBRACE | SEMICOLON ) ( sql[metaStatement] )? | COLON ident= identifier ( sql[metaStatement] )? | STRING cnst= constant ( sql[metaStatement] )? | AT col= column ( sql[metaStatement] )? | LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )? );
    public final void sql(SqlMetaStatement metaStatement) throws RecognitionException {
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMappingItem col = null;


        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:193:2: (~ ( COLON | STRING | AT | LBRACE | SEMICOLON ) ( sql[metaStatement] )? | COLON ident= identifier ( sql[metaStatement] )? | STRING cnst= constant ( sql[metaStatement] )? | AT col= column ( sql[metaStatement] )? | LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )? )
            int alt15=5;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case MAPPING:
            case OPTION:
            case RBRACE:
            case QUESTI:
            case BAND:
            case BOR:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_CHAR:
            case REST:
                {
                alt15=1;
                }
                break;
            case COLON:
                {
                alt15=2;
                }
                break;
            case STRING:
                {
                alt15=3;
                }
                break;
            case AT:
                {
                alt15=4;
                }
                break;
            case LBRACE:
                {
                alt15=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 15, 0, input);

                throw nvae;
            }

            switch (alt15) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:194:2: ~ ( COLON | STRING | AT | LBRACE | SEMICOLON ) ( sql[metaStatement] )?
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=EQUALS)||(input.LA(1)>=MAPPING && input.LA(1)<=OPTION)||(input.LA(1)>=RBRACE && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:195:40: ( sql[metaStatement] )?
                    int alt10=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt10=1;
                            }
                            break;
                    }

                    switch (alt10) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:195:40: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql365);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:196:4: COLON ident= identifier ( sql[metaStatement] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_sql372); 
                    pushFollow(FOLLOW_identifier_in_sql376);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addIdent(metaStatement, ident, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:197:67: ( sql[metaStatement] )?
                    int alt11=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt11=1;
                            }
                            break;
                    }

                    switch (alt11) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:197:67: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql383);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:198:9: STRING cnst= constant ( sql[metaStatement] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_sql395); 
                    pushFollow(FOLLOW_constant_in_sql399);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addConstant(metaStatement, cnst, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:199:74: ( sql[metaStatement] )?
                    int alt12=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt12=1;
                            }
                            break;
                    }

                    switch (alt12) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:199:74: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql411);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:200:9: AT col= column ( sql[metaStatement] )?
                    {
                    match(input,AT,FOLLOW_AT_in_sql423); 
                    pushFollow(FOLLOW_column_in_sql427);
                    col=column();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addColumn(metaStatement, col, ((meta_scope)meta_stack.peek()).text);((meta_scope)meta_stack.peek()).hasOutputMapping =true;
                    // org/sqlproc/engine/impl/SqlProcessor.g:201:100: ( sql[metaStatement] )?
                    int alt13=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt13=1;
                            }
                            break;
                    }

                    switch (alt13) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:201:100: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql439);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:202:9: LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )?
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_sql451); 
                    pushFollow(FOLLOW_metaSql_in_sql453);
                    metaSql(metaStatement);

                    state._fsp--;

                    match(input,RBRACE,FOLLOW_RBRACE_in_sql456); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:202:46: ( sql[metaStatement] )?
                    int alt14=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt14=1;
                            }
                            break;
                    }

                    switch (alt14) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:202:46: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql458);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            if(!((meta_scope)meta_stack.peek()).skip) addText(metaStatement, ((meta_scope)meta_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "sql"


    // $ANTLR start "metaSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:205:1: metaSql[SqlMetaStatement metaStatement] : (~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= NUMBER ordSql[metaOrd] );
    public final void metaSql(SqlMetaStatement metaStatement) throws RecognitionException {
        Token fragmentType=null;
        Token orderId=null;
        SqlMetaIfItem metaIfItem = null;

        SqlMetaLogExpr metaLogExpr = null;


        SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; SqlMetaOrd metaOrd; SqlMetaSqlFragment sqlFragment; if(!((meta_scope)meta_stack.peek()).skip) addText(metaStatement, ((meta_scope)meta_stack.peek()).text);
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:207:2: (~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= NUMBER ordSql[metaOrd] )
            int alt21=6;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case COLON:
            case STRING:
            case AT:
            case LBRACE:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_CHAR:
            case REST:
                {
                alt21=1;
                }
                break;
            case QUESTI:
                {
                alt21=2;
                }
                break;
            case BAND:
                {
                alt21=3;
                }
                break;
            case BOR:
                {
                alt21=4;
                }
                break;
            case EQUALS:
                {
                alt21=5;
                }
                break;
            case HASH:
                {
                alt21=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 21, 0, input);

                throw nvae;
            }

            switch (alt21) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:208:2: ~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=RPAREN)||(input.LA(1)>=SEMICOLON && input.LA(1)<=LBRACE)||(input.LA(1)>=NUMBER && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
                    pushFollow(FOLLOW_ifSql_in_metaSql516);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:210:3: ( BOR metaIfItem= ifSql[null] )*
                    loop16:
                    do {
                        int alt16=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt16=1;
                            }
                            break;

                        }

                        switch (alt16) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:210:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql525); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql529);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop16;
                        }
                    } while (true);

                    metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:211:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,QUESTI,FOLLOW_QUESTI_in_metaSql541); 
                    metaIf = new SqlMetaIf(); 
                    pushFollow(FOLLOW_ifSqlCond_in_metaSql547);
                    metaLogExpr=ifSqlCond();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.setExpression(metaLogExpr);
                    match(input,BOR,FOLLOW_BOR_in_metaSql554); 
                    pushFollow(FOLLOW_ifSql_in_metaSql558);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:213:3: ( BOR metaIfItem= ifSql[null] )*
                    loop17:
                    do {
                        int alt17=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt17=1;
                            }
                            break;

                        }

                        switch (alt17) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:213:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql567); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql571);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop17;
                        }
                    } while (true);

                    metaStatement.addElement(metaIf);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:215:4: BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,BAND,FOLLOW_BAND_in_metaSql586); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
                    pushFollow(FOLLOW_ifSql_in_metaSql592);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:216:3: ( BOR metaIfItem= ifSql[null] )*
                    loop18:
                    do {
                        int alt18=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt18=1;
                            }
                            break;

                        }

                        switch (alt18) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:216:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql601); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql605);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop18;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:217:4: BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,BOR,FOLLOW_BOR_in_metaSql617); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
                    pushFollow(FOLLOW_ifSql_in_metaSql623);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:218:3: ( BOR metaIfItem= ifSql[null] )*
                    loop19:
                    do {
                        int alt19=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt19=1;
                            }
                            break;

                        }

                        switch (alt19) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:218:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql632); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql636);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop19;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:219:4: EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null]
                    {
                    match(input,EQUALS,FOLLOW_EQUALS_in_metaSql648); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:219:11: ( WS )*
                    loop20:
                    do {
                        int alt20=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt20=1;
                            }
                            break;

                        }

                        switch (alt20) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:219:11: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_metaSql650); 

                    	    }
                    	    break;

                    	default :
                    	    break loop20;
                        }
                    } while (true);

                    fragmentType=(Token)match(input,IDENT,FOLLOW_IDENT_in_metaSql655); 
                    sqlFragment = new SqlMetaSqlFragment(fragmentType.getText());
                    pushFollow(FOLLOW_ifSql_in_metaSql661);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) sqlFragment.addElement(metaIfItem);
                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(sqlFragment);

                    }
                    break;
                case 6 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:221:4: HASH orderId= NUMBER ordSql[metaOrd]
                    {
                    match(input,HASH,FOLLOW_HASH_in_metaSql674); 
                    orderId=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_metaSql678); 
                    metaOrd = new SqlMetaOrd(Integer.parseInt(orderId.getText()));
                    pushFollow(FOLLOW_ordSql_in_metaSql682);
                    ordSql(metaOrd);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(metaOrd);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "metaSql"


    // $ANTLR start "ifSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:224:1: ifSql[SqlMetaIfItem metaIfItemIn] returns [SqlMetaIfItem metaIfItem] : (~ ( COLON | STRING | AT | LBRACE | BOR | RBRACE ) ( ifSql[metaIfItem] )? | COLON ident= identifier ( ifSql[metaIfItem] )? | STRING cnst= constant ( ifSql[metaIfItem] )? | AT col= column ( ifSql[metaIfItem] )? | LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )? );
    public final SqlMetaIfItem ifSql(SqlMetaIfItem metaIfItemIn) throws RecognitionException {
        SqlMetaIfItem metaIfItem = null;

        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMappingItem col = null;


        metaIfItem = (metaIfItemIn !=null) ? metaIfItemIn : new SqlMetaIfItem();
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:227:2: (~ ( COLON | STRING | AT | LBRACE | BOR | RBRACE ) ( ifSql[metaIfItem] )? | COLON ident= identifier ( ifSql[metaIfItem] )? | STRING cnst= constant ( ifSql[metaIfItem] )? | AT col= column ( ifSql[metaIfItem] )? | LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )? )
            int alt27=5;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case QUESTI:
            case BAND:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_CHAR:
            case REST:
                {
                alt27=1;
                }
                break;
            case COLON:
                {
                alt27=2;
                }
                break;
            case STRING:
                {
                alt27=3;
                }
                break;
            case AT:
                {
                alt27=4;
                }
                break;
            case LBRACE:
                {
                alt27=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;
            }

            switch (alt27) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:228:2: ~ ( COLON | STRING | AT | LBRACE | BOR | RBRACE ) ( ifSql[metaIfItem] )?
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=OPTION)||(input.LA(1)>=QUESTI && input.LA(1)<=BAND)||(input.LA(1)>=HASH && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:229:40: ( ifSql[metaIfItem] )?
                    int alt22=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt22=1;
                            }
                            break;
                    }

                    switch (alt22) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:229:40: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql742);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:230:4: COLON ident= identifier ( ifSql[metaIfItem] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_ifSql749); 
                    pushFollow(FOLLOW_identifier_in_ifSql753);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addIdent(metaIfItem, ident, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:231:64: ( ifSql[metaIfItem] )?
                    int alt23=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt23=1;
                            }
                            break;
                    }

                    switch (alt23) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:231:64: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql760);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:232:4: STRING cnst= constant ( ifSql[metaIfItem] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_ifSql767); 
                    pushFollow(FOLLOW_constant_in_ifSql771);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addConstant(metaIfItem, cnst, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:233:66: ( ifSql[metaIfItem] )?
                    int alt24=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt24=1;
                            }
                            break;
                    }

                    switch (alt24) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:233:66: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql778);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:234:9: AT col= column ( ifSql[metaIfItem] )?
                    {
                    match(input,AT,FOLLOW_AT_in_ifSql790); 
                    pushFollow(FOLLOW_column_in_ifSql794);
                    col=column();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addColumn(metaIfItem, col, ((meta_scope)meta_stack.peek()).text);((meta_scope)meta_stack.peek()).hasOutputMapping =true;
                    // org/sqlproc/engine/impl/SqlProcessor.g:235:97: ( ifSql[metaIfItem] )?
                    int alt25=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt25=1;
                            }
                            break;
                    }

                    switch (alt25) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:235:97: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql806);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:236:4: LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )?
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_ifSql813); 
                    pushFollow(FOLLOW_ifMetaSql_in_ifSql815);
                    ifMetaSql(metaIfItem);

                    state._fsp--;

                    match(input,RBRACE,FOLLOW_RBRACE_in_ifSql818); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:236:40: ( ifSql[metaIfItem] )?
                    int alt26=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt26=1;
                            }
                            break;
                    }

                    switch (alt26) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:236:40: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql820);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            if(!((meta_scope)meta_stack.peek()).skip) addText(metaIfItem, ((meta_scope)meta_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return metaIfItem;
    }
    // $ANTLR end "ifSql"


    // $ANTLR start "ifMetaSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:239:1: ifMetaSql[SqlMetaIfItem metaIfItem] : (~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* );
    public final void ifMetaSql(SqlMetaIfItem metaIfItem) throws RecognitionException {
        SqlMetaIfItem metaIfItem2 = null;

        SqlMetaLogExpr metaLogExpr = null;


        SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; if(!((meta_scope)meta_stack.peek()).skip) addText(metaIfItem, ((meta_scope)meta_stack.peek()).text);
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:241:2: (~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* )
            int alt32=4;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case COLON:
            case STRING:
            case AT:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_CHAR:
            case REST:
                {
                alt32=1;
                }
                break;
            case QUESTI:
                {
                alt32=2;
                }
                break;
            case BAND:
                {
                alt32=3;
                }
                break;
            case BOR:
                {
                alt32=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;
            }

            switch (alt32) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:242:2: ~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=AT)||(input.LA(1)>=HASH && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql875);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:244:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop28:
                    do {
                        int alt28=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt28=1;
                            }
                            break;

                        }

                        switch (alt28) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:244:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql884); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql888);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop28;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaAndOr);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:245:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,QUESTI,FOLLOW_QUESTI_in_ifMetaSql900); 
                    metaIf = new SqlMetaIf(); 
                    pushFollow(FOLLOW_ifSqlCond_in_ifMetaSql906);
                    metaLogExpr=ifSqlCond();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.setExpression(metaLogExpr);
                    match(input,BOR,FOLLOW_BOR_in_ifMetaSql913); 
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql917);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:247:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop29:
                    do {
                        int alt29=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt29=1;
                            }
                            break;

                        }

                        switch (alt29) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:247:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql926); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql930);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop29;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaIf);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:249:4: BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,BAND,FOLLOW_BAND_in_ifMetaSql945); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql951);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:250:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop30:
                    do {
                        int alt30=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt30=1;
                            }
                            break;

                        }

                        switch (alt30) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:250:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql960); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql964);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop30;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaAndOr);

                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:251:4: BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,BOR,FOLLOW_BOR_in_ifMetaSql976); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql982);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:252:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop31:
                    do {
                        int alt31=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt31=1;
                            }
                            break;

                        }

                        switch (alt31) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:252:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql991); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql995);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop31;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaAndOr);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ifMetaSql"


    // $ANTLR start "ifSqlCond"
    // org/sqlproc/engine/impl/SqlProcessor.g:255:1: ifSqlCond returns [SqlMetaLogExpr metaLogExpr] : ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* ;
    public final SqlMetaLogExpr ifSqlCond() throws RecognitionException {
        SqlMetaLogExpr metaLogExpr = null;

        metaLogExpr = new SqlMetaLogExpr();
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:257:2: ( ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* )
            // org/sqlproc/engine/impl/SqlProcessor.g:258:2: ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:258:2: ( WS )*
            loop33:
            do {
                int alt33=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt33=1;
                    }
                    break;

                }

                switch (alt33) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:258:2: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_ifSqlCond1022); 

            	    }
            	    break;

            	default :
            	    break loop33;
                }
            } while (true);

            pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1025);
            ifSqlBool(metaLogExpr);

            state._fsp--;

            // org/sqlproc/engine/impl/SqlProcessor.g:258:29: ( WS )*
            loop34:
            do {
                int alt34=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt34=1;
                    }
                    break;

                }

                switch (alt34) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:258:29: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_ifSqlCond1028); 

            	    }
            	    break;

            	default :
            	    break loop34;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:258:33: ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
            loop38:
            do {
                int alt38=2;
                switch ( input.LA(1) ) {
                case AND:
                case OR:
                    {
                    alt38=1;
                    }
                    break;

                }

                switch (alt38) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:258:34: ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )*
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:258:34: ( AND | OR )
            	    int alt35=2;
            	    switch ( input.LA(1) ) {
            	    case AND:
            	        {
            	        alt35=1;
            	        }
            	        break;
            	    case OR:
            	        {
            	        alt35=2;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 35, 0, input);

            	        throw nvae;
            	    }

            	    switch (alt35) {
            	        case 1 :
            	            // org/sqlproc/engine/impl/SqlProcessor.g:258:35: AND
            	            {
            	            match(input,AND,FOLLOW_AND_in_ifSqlCond1033); 
            	            if(!((meta_scope)meta_stack.peek()).skip) addOperator(metaLogExpr,true);

            	            }
            	            break;
            	        case 2 :
            	            // org/sqlproc/engine/impl/SqlProcessor.g:258:91: OR
            	            {
            	            match(input,OR,FOLLOW_OR_in_ifSqlCond1039); 
            	            if(!((meta_scope)meta_stack.peek()).skip) addOperator(metaLogExpr,false);

            	            }
            	            break;

            	    }

            	    // org/sqlproc/engine/impl/SqlProcessor.g:258:146: ( WS )*
            	    loop36:
            	    do {
            	        int alt36=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt36=1;
            	            }
            	            break;

            	        }

            	        switch (alt36) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:258:146: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_ifSqlCond1044); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop36;
            	        }
            	    } while (true);

            	    pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1049);
            	    ifSqlBool(metaLogExpr);

            	    state._fsp--;

            	    // org/sqlproc/engine/impl/SqlProcessor.g:259:26: ( WS )*
            	    loop37:
            	    do {
            	        int alt37=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt37=1;
            	            }
            	            break;

            	        }

            	        switch (alt37) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:259:26: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_ifSqlCond1052); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop37;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop38;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return metaLogExpr;
    }
    // $ANTLR end "ifSqlCond"


    // $ANTLR start "ifSqlBool"
    // org/sqlproc/engine/impl/SqlProcessor.g:262:1: ifSqlBool[SqlMetaLogExpr metaLogExpr] : ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN );
    public final void ifSqlBool(SqlMetaLogExpr metaLogExpr) throws RecognitionException {
        Token not=null;
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMetaLogExpr newMetaLogExpr = null;


        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:263:2: ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN )
            int alt42=3;
            switch ( input.LA(1) ) {
            case NOT:
                {
                switch ( input.LA(2) ) {
                case COLON:
                    {
                    alt42=1;
                    }
                    break;
                case STRING:
                    {
                    alt42=2;
                    }
                    break;
                case LPAREN:
                    {
                    alt42=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 42, 1, input);

                    throw nvae;
                }

                }
                break;
            case COLON:
                {
                alt42=1;
                }
                break;
            case STRING:
                {
                alt42=2;
                }
                break;
            case LPAREN:
                {
                alt42=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;
            }

            switch (alt42) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:264:2: (not= NOT )? COLON ident= identifier
                    {
                    // org/sqlproc/engine/impl/SqlProcessor.g:264:5: (not= NOT )?
                    int alt39=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt39=1;
                            }
                            break;
                    }

                    switch (alt39) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:264:5: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1072); 

                            }
                            break;

                    }

                    match(input,COLON,FOLLOW_COLON_in_ifSqlBool1075); 
                    pushFollow(FOLLOW_identifier_in_ifSqlBool1079);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) {ident.setNot(not!=null); addIdent(metaLogExpr, ident, ((meta_scope)meta_stack.peek()).text);}

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:265:4: (not= NOT )? STRING cnst= constant
                    {
                    // org/sqlproc/engine/impl/SqlProcessor.g:265:7: (not= NOT )?
                    int alt40=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt40=1;
                            }
                            break;
                    }

                    switch (alt40) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:265:7: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1088); 

                            }
                            break;

                    }

                    match(input,STRING,FOLLOW_STRING_in_ifSqlBool1091); 
                    pushFollow(FOLLOW_constant_in_ifSqlBool1095);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) {cnst.setNot(not!=null); addConstant(metaLogExpr, cnst, ((meta_scope)meta_stack.peek()).text);}

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:266:4: (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN
                    {
                    // org/sqlproc/engine/impl/SqlProcessor.g:266:7: (not= NOT )?
                    int alt41=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt41=1;
                            }
                            break;
                    }

                    switch (alt41) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:266:7: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1104); 

                            }
                            break;

                    }

                    match(input,LPAREN,FOLLOW_LPAREN_in_ifSqlBool1107); 
                    pushFollow(FOLLOW_ifSqlCond_in_ifSqlBool1111);
                    newMetaLogExpr=ifSqlCond();

                    state._fsp--;

                    match(input,RPAREN,FOLLOW_RPAREN_in_ifSqlBool1113); 
                    if(!((meta_scope)meta_stack.peek()).skip) metaLogExpr.addElement(newMetaLogExpr);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ifSqlBool"


    // $ANTLR start "ordSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:269:1: ordSql[SqlMetaOrd ord] : (~ ( COLON | STRING | RBRACE ) ( ordSql[ord] )? | COLON ident= identifier ( ordSql[ord] )? | STRING cnst= constant ( ordSql[ord] )? );
    public final void ordSql(SqlMetaOrd ord) throws RecognitionException {
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;


        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:271:3: (~ ( COLON | STRING | RBRACE ) ( ordSql[ord] )? | COLON ident= identifier ( ordSql[ord] )? | STRING cnst= constant ( ordSql[ord] )? )
            int alt46=3;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case AT:
            case LBRACE:
            case QUESTI:
            case BAND:
            case BOR:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_CHAR:
            case REST:
                {
                alt46=1;
                }
                break;
            case COLON:
                {
                alt46=2;
                }
                break;
            case STRING:
                {
                alt46=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 46, 0, input);

                throw nvae;
            }

            switch (alt46) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:272:2: ~ ( COLON | STRING | RBRACE ) ( ordSql[ord] )?
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=OPTION)||(input.LA(1)>=AT && input.LA(1)<=LBRACE)||(input.LA(1)>=QUESTI && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:273:40: ( ordSql[ord] )?
                    int alt43=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt43=1;
                            }
                            break;
                    }

                    switch (alt43) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:273:40: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1154);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:274:4: COLON ident= identifier ( ordSql[ord] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_ordSql1161); 
                    pushFollow(FOLLOW_identifier_in_ordSql1165);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addIdent(ord, ident, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:275:57: ( ordSql[ord] )?
                    int alt44=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt44=1;
                            }
                            break;
                    }

                    switch (alt44) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:275:57: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1172);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:276:4: STRING cnst= constant ( ordSql[ord] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_ordSql1179); 
                    pushFollow(FOLLOW_constant_in_ordSql1183);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addConstant(ord, cnst, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:277:59: ( ordSql[ord] )?
                    int alt45=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt45=1;
                            }
                            break;
                    }

                    switch (alt45) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:277:59: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1189);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            if(!((meta_scope)meta_stack.peek()).skip) addText(ord, ((meta_scope)meta_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ordSql"


    // $ANTLR start "column"
    // org/sqlproc/engine/impl/SqlProcessor.g:280:1: column returns [SqlMappingItem result] : (col= IDENT_DOT | col= IDENT | col= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMappingItem column() throws RecognitionException {
        SqlMappingItem result = null;

        Token col=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:282:2: ( (col= IDENT_DOT | col= IDENT | col= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:283:2: (col= IDENT_DOT | col= IDENT | col= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:283:2: (col= IDENT_DOT | col= IDENT | col= NUMBER )
            int alt47=3;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt47=1;
                }
                break;
            case IDENT:
                {
                alt47=2;
                }
                break;
            case NUMBER:
                {
                alt47=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;
            }

            switch (alt47) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:283:3: col= IDENT_DOT
                    {
                    col=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_column1216); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:283:19: col= IDENT
                    {
                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1222); 

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:283:31: col= NUMBER
                    {
                    col=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1228); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newColumn(col);
            // org/sqlproc/engine/impl/SqlProcessor.g:284:2: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt51=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt51=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt51) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:284:28: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_column1244); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1248); 
                     if(!((meta_scope)meta_stack.peek()).skip) setMetaType(((meta_scope)meta_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:285:3: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop50:
                    do {
                        int alt50=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt50=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt50=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt50) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:285:29: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_column1264); 
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:285:35: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt49=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt49=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt49=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 49, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt49) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:285:36: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1269); 
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:285:48: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt48=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt48=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt48) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlProcessor.g:285:73: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_column1280); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1284); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:285:97: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1292); 

                    	            }
                    	            break;

                    	    }

                    	     if(!((meta_scope)meta_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop50;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "column"


    // $ANTLR start "constant"
    // org/sqlproc/engine/impl/SqlProcessor.g:290:1: constant returns [SqlMetaConst result] : (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMetaConst constant() throws RecognitionException {
        SqlMetaConst result = null;

        Token caseCnst=null;
        Token cnst=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:292:2: ( (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:293:2: (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:293:2: (caseCnst= PLUS | caseCnst= MINUS )?
            int alt52=3;
            switch ( input.LA(1) ) {
                case PLUS:
                    {
                    alt52=1;
                    }
                    break;
                case MINUS:
                    {
                    alt52=2;
                    }
                    break;
            }

            switch (alt52) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:293:3: caseCnst= PLUS
                    {
                    caseCnst=(Token)match(input,PLUS,FOLLOW_PLUS_in_constant1329); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:293:19: caseCnst= MINUS
                    {
                    caseCnst=(Token)match(input,MINUS,FOLLOW_MINUS_in_constant1335); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlProcessor.g:293:36: (cnst= IDENT_DOT | cnst= IDENT )
            int alt53=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt53=1;
                }
                break;
            case IDENT:
                {
                alt53=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;
            }

            switch (alt53) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:293:37: cnst= IDENT_DOT
                    {
                    cnst=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_constant1342); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:293:54: cnst= IDENT
                    {
                    cnst=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1348); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newConstant(cnst, caseCnst);
            // org/sqlproc/engine/impl/SqlProcessor.g:294:2: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt57=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt57=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt57) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:294:28: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_constant1364); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1368); 
                     if(!((meta_scope)meta_stack.peek()).skip) setMetaType(((meta_scope)meta_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:295:3: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop56:
                    do {
                        int alt56=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt56=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt56=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt56) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:295:29: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_constant1384); 
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:295:35: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt55=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt55=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt55=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 55, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt55) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:295:36: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1389); 
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:295:48: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt54=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt54=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt54) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlProcessor.g:295:73: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_constant1400); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1404); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:295:97: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_constant1412); 

                    	            }
                    	            break;

                    	    }

                    	     if(!((meta_scope)meta_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop56;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "constant"


    // $ANTLR start "identifier"
    // org/sqlproc/engine/impl/SqlProcessor.g:300:1: identifier returns [SqlMetaIdent result] : (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )? (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT | ident= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMetaIdent identifier() throws RecognitionException {
        SqlMetaIdent result = null;

        Token modeIdent=null;
        Token caseIdent=null;
        Token ident=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:302:2: ( (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )? (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT | ident= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:303:2: (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )? (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT | ident= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:303:2: (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )?
            int alt58=4;
            switch ( input.LA(1) ) {
                case EQUALS:
                    {
                    alt58=1;
                    }
                    break;
                case LESS_THAN:
                    {
                    alt58=2;
                    }
                    break;
                case MORE_THAN:
                    {
                    alt58=3;
                    }
                    break;
            }

            switch (alt58) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:3: modeIdent= EQUALS
                    {
                    modeIdent=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_identifier1449); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:22: modeIdent= LESS_THAN
                    {
                    modeIdent=(Token)match(input,LESS_THAN,FOLLOW_LESS_THAN_in_identifier1455); 

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:44: modeIdent= MORE_THAN
                    {
                    modeIdent=(Token)match(input,MORE_THAN,FOLLOW_MORE_THAN_in_identifier1461); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlProcessor.g:303:66: (caseIdent= PLUS | caseIdent= MINUS )?
            int alt59=3;
            switch ( input.LA(1) ) {
                case PLUS:
                    {
                    alt59=1;
                    }
                    break;
                case MINUS:
                    {
                    alt59=2;
                    }
                    break;
            }

            switch (alt59) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:67: caseIdent= PLUS
                    {
                    caseIdent=(Token)match(input,PLUS,FOLLOW_PLUS_in_identifier1468); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:84: caseIdent= MINUS
                    {
                    caseIdent=(Token)match(input,MINUS,FOLLOW_MINUS_in_identifier1474); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlProcessor.g:303:102: (ident= IDENT_DOT | ident= IDENT | ident= NUMBER )
            int alt60=3;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt60=1;
                }
                break;
            case IDENT:
                {
                alt60=2;
                }
                break;
            case NUMBER:
                {
                alt60=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;
            }

            switch (alt60) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:103: ident= IDENT_DOT
                    {
                    ident=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_identifier1481); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:121: ident= IDENT
                    {
                    ident=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1487); 

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:303:135: ident= NUMBER
                    {
                    ident=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1493); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newIdent(ident, modeIdent, caseIdent);
            // org/sqlproc/engine/impl/SqlProcessor.g:304:2: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt64=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt64=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt64) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:304:28: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_identifier1509); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1513); 
                     if(!((meta_scope)meta_stack.peek()).skip) setMetaType(((meta_scope)meta_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:305:3: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop63:
                    do {
                        int alt63=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt63=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt63=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt63) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:305:29: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_identifier1529); 
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:305:35: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt62=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt62=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt62=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 62, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt62) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:305:36: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1534); 
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:305:48: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt61=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt61=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt61) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlProcessor.g:305:73: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_identifier1545); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1549); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:305:97: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1557); 

                    	            }
                    	            break;

                    	    }

                    	     if(!((meta_scope)meta_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop63;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "identifier"

    protected static class mapping_scope {
        SqlTypeFactory typeFactory;
        boolean skip;
    }
    protected Stack mapping_stack = new Stack();


    // $ANTLR start "mapping"
    // org/sqlproc/engine/impl/SqlProcessor.g:311:1: mapping[String name, SqlTypeFactory _typeFactory, boolean _skip] returns [SqlMappingRule sqlMapping] : ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? ) ;
    public final SqlMappingRule mapping(String name, SqlTypeFactory _typeFactory, boolean _skip) throws RecognitionException {
        mapping_stack.push(new mapping_scope());
        SqlMappingRule sqlMapping = null;

        SqlMappingItem sqlMappingItem = null;


        artifactName.push(name); sqlMapping = new SqlMappingRule();((mapping_scope)mapping_stack.peek()).typeFactory =_typeFactory; ((mapping_scope)mapping_stack.peek()).skip =_skip;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:315:1: ( ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? ) )
            // org/sqlproc/engine/impl/SqlProcessor.g:316:1: ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? )
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:316:1: ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:317:3: ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:317:3: ( WS )*
            loop65:
            do {
                int alt65=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt65=1;
                    }
                    break;

                }

                switch (alt65) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:317:3: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_mapping1604); 

            	    }
            	    break;

            	default :
            	    break loop65;
                }
            } while (true);

            pushFollow(FOLLOW_mappingItem_in_mapping1611);
            sqlMappingItem=mappingItem();

            state._fsp--;

            if(!((mapping_scope)mapping_stack.peek()).skip) sqlMapping.addMapping(sqlMappingItem);
            // org/sqlproc/engine/impl/SqlProcessor.g:319:3: ( ( WS )+ sqlMappingItem= mappingItem )*
            loop67:
            do {
                int alt67=2;
                alt67 = dfa67.predict(input);
                switch (alt67) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:319:4: ( WS )+ sqlMappingItem= mappingItem
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:319:4: ( WS )+
            	    int cnt66=0;
            	    loop66:
            	    do {
            	        int alt66=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt66=1;
            	            }
            	            break;

            	        }

            	        switch (alt66) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:319:4: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_mapping1618); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    if ( cnt66 >= 1 ) break loop66;
            	                EarlyExitException eee =
            	                    new EarlyExitException(66, input);
            	                throw eee;
            	        }
            	        cnt66++;
            	    } while (true);

            	    pushFollow(FOLLOW_mappingItem_in_mapping1623);
            	    sqlMappingItem=mappingItem();

            	    state._fsp--;

            	    if(!((mapping_scope)mapping_stack.peek()).skip) sqlMapping.addMapping(sqlMappingItem);

            	    }
            	    break;

            	default :
            	    break loop67;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:320:3: ( WS )*
            loop68:
            do {
                int alt68=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt68=1;
                    }
                    break;

                }

                switch (alt68) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:320:3: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_mapping1631); 

            	    }
            	    break;

            	default :
            	    break loop68;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:320:8: ( EOF )?
            int alt69=2;
            switch ( input.LA(1) ) {
                case EOF:
                    {
                    alt69=1;
                    }
                    break;
            }

            switch (alt69) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:320:8: EOF
                    {
                    match(input,EOF,FOLLOW_EOF_in_mapping1635); 

                    }
                    break;

            }


            }


            }

             artifactName.pop();
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            mapping_stack.pop();
        }
        return sqlMapping;
    }
    // $ANTLR end "mapping"


    // $ANTLR start "mappingItem"
    // org/sqlproc/engine/impl/SqlProcessor.g:324:1: mappingItem returns [SqlMappingItem result] : (col= IDENT | col= NUMBER ) ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )? ;
    public final SqlMappingItem mappingItem() throws RecognitionException {
        SqlMappingItem result = null;

        Token col=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:326:2: ( (col= IDENT | col= NUMBER ) ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:327:2: (col= IDENT | col= NUMBER ) ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:327:2: (col= IDENT | col= NUMBER )
            int alt70=2;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt70=1;
                }
                break;
            case NUMBER:
                {
                alt70=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;
            }

            switch (alt70) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:327:3: col= IDENT
                    {
                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1661); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:327:15: col= NUMBER
                    {
                    col=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem1667); 

                    }
                    break;

            }

            if(!((mapping_scope)mapping_stack.peek()).skip) result = newColumn(col);
            // org/sqlproc/engine/impl/SqlProcessor.g:328:3: ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )?
            int alt77=2;
            switch ( input.LA(1) ) {
                case STRING:
                    {
                    alt77=1;
                    }
                    break;
            }

            switch (alt77) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:328:29: STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_mappingItem1684); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:328:36: (type= IDENT )?
                    int alt71=2;
                    switch ( input.LA(1) ) {
                        case IDENT:
                            {
                            alt71=1;
                            }
                            break;
                    }

                    switch (alt71) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:328:37: type= IDENT
                            {
                            type=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1689); 
                             if(!((mapping_scope)mapping_stack.peek()).skip) setMetaType(((mapping_scope)mapping_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 

                            }
                            break;

                    }

                    // org/sqlproc/engine/impl/SqlProcessor.g:329:4: ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
                    int alt76=2;
                    switch ( input.LA(1) ) {
                        case STRING:
                            {
                            alt76=1;
                            }
                            break;
                    }

                    switch (alt76) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:329:5: STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                            {
                            match(input,STRING,FOLLOW_STRING_in_mappingItem1699); 
                            // org/sqlproc/engine/impl/SqlProcessor.g:329:12: (col= IDENT_DOT | col= IDENT )
                            int alt72=2;
                            switch ( input.LA(1) ) {
                            case IDENT_DOT:
                                {
                                alt72=1;
                                }
                                break;
                            case IDENT:
                                {
                                alt72=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 72, 0, input);

                                throw nvae;
                            }

                            switch (alt72) {
                                case 1 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:329:13: col= IDENT_DOT
                                    {
                                    col=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_mappingItem1704); 

                                    }
                                    break;
                                case 2 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:329:29: col= IDENT
                                    {
                                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1710); 

                                    }
                                    break;

                            }

                             if(!((mapping_scope)mapping_stack.peek()).skip) addColumnAttr(result, col); 
                            // org/sqlproc/engine/impl/SqlProcessor.g:330:5: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                            loop75:
                            do {
                                int alt75=2;
                                switch ( input.LA(1) ) {
                                case CARET:
                                    {
                                    alt75=1;
                                    }
                                    break;

                                }

                                switch (alt75) {
                            	case 1 :
                            	    // org/sqlproc/engine/impl/SqlProcessor.g:330:31: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                            	    {
                            	    match(input,CARET,FOLLOW_CARET_in_mappingItem1729); 
                            	    // org/sqlproc/engine/impl/SqlProcessor.g:330:37: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                            	    int alt74=2;
                            	    switch ( input.LA(1) ) {
                            	    case IDENT:
                            	        {
                            	        alt74=1;
                            	        }
                            	        break;
                            	    case NUMBER:
                            	        {
                            	        alt74=2;
                            	        }
                            	        break;
                            	    default:
                            	        NoViableAltException nvae =
                            	            new NoViableAltException("", 74, 0, input);

                            	        throw nvae;
                            	    }

                            	    switch (alt74) {
                            	        case 1 :
                            	            // org/sqlproc/engine/impl/SqlProcessor.g:330:38: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                            	            {
                            	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1734); 
                            	            // org/sqlproc/engine/impl/SqlProcessor.g:330:50: ( options {greedy=true; } : EQUALS value2= IDENT )?
                            	            int alt73=2;
                            	            switch ( input.LA(1) ) {
                            	                case EQUALS:
                            	                    {
                            	                    alt73=1;
                            	                    }
                            	                    break;
                            	            }

                            	            switch (alt73) {
                            	                case 1 :
                            	                    // org/sqlproc/engine/impl/SqlProcessor.g:330:75: EQUALS value2= IDENT
                            	                    {
                            	                    match(input,EQUALS,FOLLOW_EQUALS_in_mappingItem1745); 
                            	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1749); 

                            	                    }
                            	                    break;

                            	            }


                            	            }
                            	            break;
                            	        case 2 :
                            	            // org/sqlproc/engine/impl/SqlProcessor.g:330:99: value= NUMBER
                            	            {
                            	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem1757); 

                            	            }
                            	            break;

                            	    }

                            	     if(!((mapping_scope)mapping_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                            	    }
                            	    break;

                            	default :
                            	    break loop75;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "mappingItem"


    // $ANTLR start "option"
    // org/sqlproc/engine/impl/SqlProcessor.g:336:1: option[String name] returns [StringBuilder text] : (~ ( SEMICOLON ) )+ ;
    public final StringBuilder option(String name) throws RecognitionException {
        StringBuilder text = null;

        artifactName.push(name); text = new StringBuilder();
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:339:2: ( (~ ( SEMICOLON ) )+ )
            // org/sqlproc/engine/impl/SqlProcessor.g:339:4: (~ ( SEMICOLON ) )+
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:339:4: (~ ( SEMICOLON ) )+
            int cnt78=0;
            loop78:
            do {
                int alt78=2;
                switch ( input.LA(1) ) {
                case WS:
                case IDENT:
                case LPAREN:
                case STATEMENT:
                case COMMA:
                case RPAREN:
                case EQUALS:
                case MAPPING:
                case OPTION:
                case COLON:
                case STRING:
                case AT:
                case LBRACE:
                case RBRACE:
                case QUESTI:
                case BAND:
                case BOR:
                case HASH:
                case NUMBER:
                case AND:
                case OR:
                case NOT:
                case IDENT_DOT:
                case CARET:
                case PLUS:
                case MINUS:
                case LESS_THAN:
                case MORE_THAN:
                case DOT:
                case DIGIT:
                case ESC_COLON:
                case ESC_SEMICOLON:
                case ESC_STRING:
                case ESC_LBRACE:
                case ESC_RBRACE:
                case ESC_BOR:
                case ESC_HASH:
                case ESC_AT:
                case ESC_CHAR:
                case REST:
                    {
                    alt78=1;
                    }
                    break;

                }

                switch (alt78) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:339:5: ~ ( SEMICOLON )
            	    {
            	    if ( (input.LA(1)>=WS && input.LA(1)<=EQUALS)||(input.LA(1)>=MAPPING && input.LA(1)<=REST) ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }

            	    add(text);

            	    }
            	    break;

            	default :
            	    if ( cnt78 >= 1 ) break loop78;
                        EarlyExitException eee =
                            new EarlyExitException(78, input);
                        throw eee;
                }
                cnt78++;
            } while (true);


            }

             artifactName.pop();
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return text;
    }
    // $ANTLR end "option"

    // Delegated rules


    protected DFA67 dfa67 = new DFA67(this);
    static final String DFA67_eotS =
        "\4\uffff";
    static final String DFA67_eofS =
        "\2\2\2\uffff";
    static final String DFA67_minS =
        "\2\4\2\uffff";
    static final String DFA67_maxS =
        "\1\13\1\27\2\uffff";
    static final String DFA67_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA67_specialS =
        "\4\uffff}>";
    static final String[] DFA67_transitionS = {
            "\1\1\6\uffff\1\2",
            "\1\1\1\3\5\uffff\1\2\13\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA67_eot = DFA.unpackEncodedString(DFA67_eotS);
    static final short[] DFA67_eof = DFA.unpackEncodedString(DFA67_eofS);
    static final char[] DFA67_min = DFA.unpackEncodedStringToUnsignedChars(DFA67_minS);
    static final char[] DFA67_max = DFA.unpackEncodedStringToUnsignedChars(DFA67_maxS);
    static final short[] DFA67_accept = DFA.unpackEncodedString(DFA67_acceptS);
    static final short[] DFA67_special = DFA.unpackEncodedString(DFA67_specialS);
    static final short[][] DFA67_transition;

    static {
        int numStates = DFA67_transitionS.length;
        DFA67_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA67_transition[i] = DFA.unpackEncodedString(DFA67_transitionS[i]);
        }
    }

    class DFA67 extends DFA {

        public DFA67(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 67;
            this.eot = DFA67_eot;
            this.eof = DFA67_eof;
            this.min = DFA67_min;
            this.max = DFA67_max;
            this.accept = DFA67_accept;
            this.special = DFA67_special;
            this.transition = DFA67_transition;
        }
        public String getDescription() {
            return "()* loopback of 319:3: ( ( WS )+ sqlMappingItem= mappingItem )*";
        }
    }
 

    public static final BitSet FOLLOW_WS_in_parse73 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_parse90 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_parse94 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_STATEMENT_in_parse98 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_COMMA_in_parse103 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_parse107 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_RPAREN_in_parse113 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_EQUALS_in_parse115 = new BitSet(new long[]{0x00001FFFFFFFF7F0L});
    public static final BitSet FOLLOW_meta_in_parse131 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_SEMICOLON_in_parse136 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_parse138 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_parse156 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_parse160 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_MAPPING_in_parse164 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_COMMA_in_parse169 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_parse173 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_RPAREN_in_parse179 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_EQUALS_in_parse181 = new BitSet(new long[]{0x0000000000800030L});
    public static final BitSet FOLLOW_mapping_in_parse197 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_SEMICOLON_in_parse202 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_parse204 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_parse222 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_parse224 = new BitSet(new long[]{0x0000000000002000L});
    public static final BitSet FOLLOW_OPTION_in_parse228 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_COMMA_in_parse233 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_parse237 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_RPAREN_in_parse243 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_EQUALS_in_parse245 = new BitSet(new long[]{0x00001FFFFFFFF7F0L});
    public static final BitSet FOLLOW_option_in_parse261 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_SEMICOLON_in_parse266 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_parse268 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_EOF_in_parse283 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sql_in_meta315 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EOF_in_meta318 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_sql340 = new BitSet(new long[]{0x00001FFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql365 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_sql372 = new BitSet(new long[]{0x00000001E8800420L});
    public static final BitSet FOLLOW_identifier_in_sql376 = new BitSet(new long[]{0x00001FFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql383 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_sql395 = new BitSet(new long[]{0x0000000068000020L});
    public static final BitSet FOLLOW_constant_in_sql399 = new BitSet(new long[]{0x00001FFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql411 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_sql423 = new BitSet(new long[]{0x0000000008800020L});
    public static final BitSet FOLLOW_column_in_sql427 = new BitSet(new long[]{0x00001FFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql439 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACE_in_sql451 = new BitSet(new long[]{0x00001FFFFFFBFFF0L});
    public static final BitSet FOLLOW_metaSql_in_sql453 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_RBRACE_in_sql456 = new BitSet(new long[]{0x00001FFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql458 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_metaSql485 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql516 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_metaSql525 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql529 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_QUESTI_in_metaSql541 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_ifSqlCond_in_metaSql547 = new BitSet(new long[]{0x0000000000200000L});
    public static final BitSet FOLLOW_BOR_in_metaSql554 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql558 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_metaSql567 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql571 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BAND_in_metaSql586 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql592 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_metaSql601 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql605 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_metaSql617 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql623 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_metaSql632 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql636 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_EQUALS_in_metaSql648 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_metaSql650 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_metaSql655 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql661 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HASH_in_metaSql674 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_NUMBER_in_metaSql678 = new BitSet(new long[]{0x00001FFFFFFBFFF0L});
    public static final BitSet FOLLOW_ordSql_in_metaSql682 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ifSql713 = new BitSet(new long[]{0x00001FFFFFDBFFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql742 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_ifSql749 = new BitSet(new long[]{0x00000001E8800420L});
    public static final BitSet FOLLOW_identifier_in_ifSql753 = new BitSet(new long[]{0x00001FFFFFDBFFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql760 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_ifSql767 = new BitSet(new long[]{0x0000000068000020L});
    public static final BitSet FOLLOW_constant_in_ifSql771 = new BitSet(new long[]{0x00001FFFFFDBFFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql778 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_ifSql790 = new BitSet(new long[]{0x0000000008800020L});
    public static final BitSet FOLLOW_column_in_ifSql794 = new BitSet(new long[]{0x00001FFFFFDBFFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql806 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACE_in_ifSql813 = new BitSet(new long[]{0x00001FFFFFF9FFF0L});
    public static final BitSet FOLLOW_ifMetaSql_in_ifSql815 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_RBRACE_in_ifSql818 = new BitSet(new long[]{0x00001FFFFFDBFFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql820 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ifMetaSql848 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql875 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql884 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql888 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_QUESTI_in_ifMetaSql900 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_ifSqlCond_in_ifMetaSql906 = new BitSet(new long[]{0x0000000000200000L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql913 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql917 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql926 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql930 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BAND_in_ifMetaSql945 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql951 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql960 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql964 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql976 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql982 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql991 = new BitSet(new long[]{0x00001FFFFFDBFFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql995 = new BitSet(new long[]{0x0000000000200002L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1022 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1025 = new BitSet(new long[]{0x0000000003000012L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1028 = new BitSet(new long[]{0x0000000003000012L});
    public static final BitSet FOLLOW_AND_in_ifSqlCond1033 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_OR_in_ifSqlCond1039 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1044 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1049 = new BitSet(new long[]{0x0000000003000012L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1052 = new BitSet(new long[]{0x0000000003000012L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1072 = new BitSet(new long[]{0x0000000000004000L});
    public static final BitSet FOLLOW_COLON_in_ifSqlBool1075 = new BitSet(new long[]{0x00000001E8800420L});
    public static final BitSet FOLLOW_identifier_in_ifSqlBool1079 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1088 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_STRING_in_ifSqlBool1091 = new BitSet(new long[]{0x0000000068000020L});
    public static final BitSet FOLLOW_constant_in_ifSqlBool1095 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1104 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_ifSqlBool1107 = new BitSet(new long[]{0x000000000400C050L});
    public static final BitSet FOLLOW_ifSqlCond_in_ifSqlBool1111 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_RPAREN_in_ifSqlBool1113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ordSql1137 = new BitSet(new long[]{0x00001FFFFFFBFFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_ordSql1161 = new BitSet(new long[]{0x00000001E8800420L});
    public static final BitSet FOLLOW_identifier_in_ordSql1165 = new BitSet(new long[]{0x00001FFFFFFBFFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_ordSql1179 = new BitSet(new long[]{0x0000000068000020L});
    public static final BitSet FOLLOW_constant_in_ordSql1183 = new BitSet(new long[]{0x00001FFFFFFBFFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1189 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_DOT_in_column1216 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_IDENT_in_column1222 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_NUMBER_in_column1228 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_column1244 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_column1248 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_column1264 = new BitSet(new long[]{0x0000000000800020L});
    public static final BitSet FOLLOW_IDENT_in_column1269 = new BitSet(new long[]{0x0000000010000402L});
    public static final BitSet FOLLOW_EQUALS_in_column1280 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_column1284 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_NUMBER_in_column1292 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_PLUS_in_constant1329 = new BitSet(new long[]{0x0000000008000020L});
    public static final BitSet FOLLOW_MINUS_in_constant1335 = new BitSet(new long[]{0x0000000008000020L});
    public static final BitSet FOLLOW_IDENT_DOT_in_constant1342 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_IDENT_in_constant1348 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_constant1364 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1368 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_constant1384 = new BitSet(new long[]{0x0000000000800020L});
    public static final BitSet FOLLOW_IDENT_in_constant1389 = new BitSet(new long[]{0x0000000010000402L});
    public static final BitSet FOLLOW_EQUALS_in_constant1400 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1404 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_NUMBER_in_constant1412 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_EQUALS_in_identifier1449 = new BitSet(new long[]{0x0000000068800020L});
    public static final BitSet FOLLOW_LESS_THAN_in_identifier1455 = new BitSet(new long[]{0x0000000068800020L});
    public static final BitSet FOLLOW_MORE_THAN_in_identifier1461 = new BitSet(new long[]{0x0000000068800020L});
    public static final BitSet FOLLOW_PLUS_in_identifier1468 = new BitSet(new long[]{0x0000000008800020L});
    public static final BitSet FOLLOW_MINUS_in_identifier1474 = new BitSet(new long[]{0x0000000008800020L});
    public static final BitSet FOLLOW_IDENT_DOT_in_identifier1481 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_IDENT_in_identifier1487 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_NUMBER_in_identifier1493 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_identifier1509 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1513 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_identifier1529 = new BitSet(new long[]{0x0000000000800020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1534 = new BitSet(new long[]{0x0000000010000402L});
    public static final BitSet FOLLOW_EQUALS_in_identifier1545 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1549 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_NUMBER_in_identifier1557 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_WS_in_mapping1604 = new BitSet(new long[]{0x0000000000800030L});
    public static final BitSet FOLLOW_mappingItem_in_mapping1611 = new BitSet(new long[]{0x0000000000000012L});
    public static final BitSet FOLLOW_WS_in_mapping1618 = new BitSet(new long[]{0x0000000000800030L});
    public static final BitSet FOLLOW_mappingItem_in_mapping1623 = new BitSet(new long[]{0x0000000000000012L});
    public static final BitSet FOLLOW_WS_in_mapping1631 = new BitSet(new long[]{0x0000000000000012L});
    public static final BitSet FOLLOW_EOF_in_mapping1635 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1661 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_NUMBER_in_mappingItem1667 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_STRING_in_mappingItem1684 = new BitSet(new long[]{0x0000000000008022L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1689 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_STRING_in_mappingItem1699 = new BitSet(new long[]{0x0000000008000020L});
    public static final BitSet FOLLOW_IDENT_DOT_in_mappingItem1704 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1710 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_CARET_in_mappingItem1729 = new BitSet(new long[]{0x0000000000800020L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1734 = new BitSet(new long[]{0x0000000010000402L});
    public static final BitSet FOLLOW_EQUALS_in_mappingItem1745 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1749 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_NUMBER_in_mappingItem1757 = new BitSet(new long[]{0x0000000010000002L});
    public static final BitSet FOLLOW_set_in_option1809 = new BitSet(new long[]{0x00001FFFFFFFF7F2L});

}