/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.impl.SqlUtils;

public class SqlStandardControl
implements SqlControl {
    private Object staticInputValues;
    private int maxTimeout;
    private int firstResult;
    private int maxResults;
    private SqlOrder order;
    private Map<String, Class<?>> moreResultClasses;
    private Map<String, Object> features = new HashMap<String, Object>();
    private String processingId;
    private int fetchSize;

    public SqlStandardControl() {
    }

    public SqlStandardControl(SqlControl sqlControl) {
        if (sqlControl != null) {
            this.setStaticInputValues(sqlControl.getStaticInputValues());
            this.setFirstResult(sqlControl.getFirstResult());
            this.setMaxResults(sqlControl.getMaxResults());
            this.setMaxTimeout(sqlControl.getMaxTimeout());
            this.setMoreResultClasses(sqlControl.getMoreResultClasses());
            this.setOrder(sqlControl.getOrder());
            this.setFeatures(sqlControl.getFeatures());
            this.setProcessingId(sqlControl.getProcessingId());
        }
    }

    @Override
    public Object getStaticInputValues() {
        return this.staticInputValues;
    }

    public SqlStandardControl setStaticInputValues(Object staticInputValues) {
        this.staticInputValues = staticInputValues;
        return this;
    }

    @Override
    public int getMaxTimeout() {
        return this.maxTimeout;
    }

    public SqlStandardControl setMaxTimeout(int maxTimeout) {
        this.maxTimeout = maxTimeout;
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.firstResult;
    }

    public SqlStandardControl setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    public SqlStandardControl setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public SqlOrder getOrder() {
        return this.order;
    }

    public SqlStandardControl setOrder(SqlOrder order) {
        this.order = order;
        return this;
    }

    public SqlStandardControl setAscOrder(int order) {
        this.order = SqlOrder.getAscOrder(order);
        return this;
    }

    public SqlStandardControl setDescOrder(int order) {
        this.order = SqlOrder.getDescOrder(order);
        return this;
    }

    @Override
    public Map<String, Class<?>> getMoreResultClasses() {
        return this.moreResultClasses;
    }

    public SqlStandardControl setMoreResultClasses(Map<String, Class<?>> moreResultClasses) {
        this.moreResultClasses = moreResultClasses;
        return this;
    }

    @Override
    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public SqlStandardControl setFeatures(Map<String, Object> features) {
        this.features = features;
        return this;
    }

    public SqlStandardControl setFeature(String name, Object value) {
        this.features.put(name, value);
        this.unsetFeatures(SqlUtils.oppositeFeatures(name));
        return this;
    }

    public SqlStandardControl unsetFeatures(Set<String> names) {
        if (names != null) {
            for (String name : names) {
                this.features.remove(name);
            }
        }
        return this;
    }

    @Override
    public String getProcessingId() {
        return this.processingId;
    }

    public SqlStandardControl setProcessingId(String processingId) {
        this.processingId = processingId;
        return this;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public SqlStandardControl setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public String toString() {
        return "SqlStandardControl [staticInputValues=" + this.staticInputValues + ", maxTimeout=" + this.maxTimeout + ", firstResult=" + this.firstResult + ", maxResults=" + this.maxResults + ", order=" + this.order + ", moreResultClasses=" + this.moreResultClasses + ", features=" + this.features + ", processingId=" + this.processingId + "]";
    }
}

