/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.config.store.SqlEngineConfigurationStore;
import org.sqlproc.engine.config.store.XmlEngineConfiguration;
import org.sqlproc.engine.impl.config.store.SimpleEngineConfigurationStore;

public class SqlEngineConfiguration {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<String, AtomicInteger> queryEngines = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicInteger> crudEngines = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicInteger> procedureEngines = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> dynamicQueryEngines = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> dynamicCrudEngines = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> dynamicProcedureEngines = new ConcurrentHashMap();
    private Boolean lazyInit;
    private Integer asyncInitThreads;
    private Integer initTreshold;
    private Boolean initInUsageOrder;
    private Boolean initClearUsage;
    private SqlEngineConfigurationStore store;

    public SqlEngineConfiguration(String directory, String fileName) throws IOException, JAXBException {
        this.store = new SimpleEngineConfigurationStore(directory, fileName, XmlEngineConfiguration.class, XmlEngineConfiguration.EngineUsage.class, XmlEngineConfiguration.EngineSql.class);
    }

    public SqlEngineConfiguration(SqlEngineConfigurationStore jaxbStore) {
        this.store = jaxbStore;
    }

    public void load() throws JAXBException {
        this.logger.warn(">>> load");
        boolean ok = this.store.readConfig(this);
        this.logger.warn("=== load ok={}", (Object)ok);
        this.logger.warn("<<< load this={}", (Object)this);
    }

    public void store() {
        this.logger.warn(">>> store this={}", (Object)this);
        this.store.writeConfig(this);
        this.logger.warn("<<< store");
    }

    public void clear() {
        this.queryEngines = new ConcurrentHashMap();
        this.crudEngines = new ConcurrentHashMap();
        this.procedureEngines = new ConcurrentHashMap();
        this.dynamicQueryEngines = new ConcurrentHashMap();
        this.dynamicCrudEngines = new ConcurrentHashMap();
        this.dynamicProcedureEngines = new ConcurrentHashMap();
        this.lazyInit = null;
        this.asyncInitThreads = null;
        this.initTreshold = null;
        this.initInUsageOrder = null;
        this.initClearUsage = null;
    }

    public void clearUsage() {
        this.queryEngines = new ConcurrentHashMap();
        this.crudEngines = new ConcurrentHashMap();
        this.procedureEngines = new ConcurrentHashMap();
    }

    protected int addEngine(String name, ConcurrentHashMap<String, AtomicInteger> engines) {
        AtomicInteger counter = engines.get(name);
        if (counter == null) {
            counter = engines.putIfAbsent(name, new AtomicInteger(1));
        }
        if (counter == null) {
            return 1;
        }
        return counter.addAndGet(1);
    }

    protected int removeEngine(String name, ConcurrentHashMap<String, AtomicInteger> engines) {
        AtomicInteger counter = engines.remove(name);
        return counter == null ? 0 : counter.get();
    }

    public int addQueryEngine(String name) {
        return this.addEngine(name, this.queryEngines);
    }

    public int addCrudEngine(String name) {
        return this.addEngine(name, this.crudEngines);
    }

    public int addProcedureEngine(String name) {
        return this.addEngine(name, this.procedureEngines);
    }

    public int removeQueryEngine(String name) {
        return this.removeEngine(name, this.queryEngines);
    }

    public int removeCrudEngine(String name) {
        return this.removeEngine(name, this.crudEngines);
    }

    public int removeProcedureEngine(String name) {
        return this.removeEngine(name, this.procedureEngines);
    }

    public int addDynamicQueryEngine(String name, String sqlStatement) {
        this.dynamicQueryEngines.put(name, sqlStatement);
        return this.addQueryEngine(name);
    }

    public int addDynamicCrudEngine(String name, String sqlStatement) {
        this.dynamicCrudEngines.put(name, sqlStatement);
        return this.addCrudEngine(name);
    }

    public int addDynamicProcedureEngine(String name, String sqlStatement) {
        this.dynamicProcedureEngines.put(name, sqlStatement);
        return this.addProcedureEngine(name);
    }

    public int removeDynamicQueryEngine(String name) {
        this.dynamicQueryEngines.remove(name);
        AtomicInteger counter = this.queryEngines.get(name);
        return counter == null ? 0 : counter.get();
    }

    public int removeDynamicCrudEngine(String name) {
        this.dynamicCrudEngines.remove(name);
        AtomicInteger counter = this.crudEngines.get(name);
        return counter == null ? 0 : counter.get();
    }

    public int removeDynamicProcedureEngine(String name) {
        this.dynamicProcedureEngines.remove(name);
        AtomicInteger counter = this.procedureEngines.get(name);
        return counter == null ? 0 : counter.get();
    }

    public ConcurrentHashMap<String, AtomicInteger> getQueryEngines() {
        return this.queryEngines;
    }

    public ConcurrentHashMap<String, AtomicInteger> getCrudEngines() {
        return this.crudEngines;
    }

    public ConcurrentHashMap<String, AtomicInteger> getProcedureEngines() {
        return this.procedureEngines;
    }

    public ConcurrentHashMap<String, String> getDynamicQueryEngines() {
        return this.dynamicQueryEngines;
    }

    public ConcurrentHashMap<String, String> getDynamicCrudEngines() {
        return this.dynamicCrudEngines;
    }

    public ConcurrentHashMap<String, String> getDynamicProcedureEngines() {
        return this.dynamicProcedureEngines;
    }

    public void setQueryEngines(ConcurrentHashMap<String, AtomicInteger> queryEngines) {
        this.queryEngines = queryEngines;
    }

    public void setCrudEngines(ConcurrentHashMap<String, AtomicInteger> crudEngines) {
        this.crudEngines = crudEngines;
    }

    public void setProcedureEngines(ConcurrentHashMap<String, AtomicInteger> procedureEngines) {
        this.procedureEngines = procedureEngines;
    }

    public void setDynamicQueryEngines(ConcurrentHashMap<String, String> dynamicQueryEngines) {
        this.dynamicQueryEngines = dynamicQueryEngines;
    }

    public void setDynamicCrudEngines(ConcurrentHashMap<String, String> dynamicCrudEngines) {
        this.dynamicCrudEngines = dynamicCrudEngines;
    }

    public void setDynamicProcedureEngines(ConcurrentHashMap<String, String> dynamicProcedureEngines) {
        this.dynamicProcedureEngines = dynamicProcedureEngines;
    }

    public Boolean getLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(Boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public Integer getAsyncInitThreads() {
        return this.asyncInitThreads;
    }

    public void setAsyncInitThreads(Integer asyncInitThreads) {
        this.asyncInitThreads = asyncInitThreads;
    }

    public Integer getInitTreshold() {
        return this.initTreshold;
    }

    public void setInitTreshold(Integer initTreshold) {
        this.initTreshold = initTreshold;
    }

    public Boolean getInitInUsageOrder() {
        return this.initInUsageOrder;
    }

    public void setInitInUsageOrder(Boolean initInUsageOrder) {
        this.initInUsageOrder = initInUsageOrder;
    }

    public Boolean getInitClearUsage() {
        return this.initClearUsage;
    }

    public void setInitClearUsage(Boolean initClearUsage) {
        this.initClearUsage = initClearUsage;
    }

    protected Map<String, Integer> getEnginesToInit(ConcurrentHashMap<String, AtomicInteger> engines, Integer treshold) {
        TreeMap<String, Integer> map;
        if (this.initInUsageOrder != null && this.initInUsageOrder.booleanValue()) {
            map = new LinkedHashMap();
            ArrayList<NameValue> list = new ArrayList<NameValue>();
            for (Map.Entry<String, AtomicInteger> e : engines.entrySet()) {
                if (this.initTreshold != null && e.getValue().get() < this.initTreshold) continue;
                list.add(new NameValue(e.getKey(), e.getValue().get()));
            }
            for (NameValue nv : list) {
                map.put(nv.name, nv.value);
            }
        } else {
            map = new TreeMap();
            for (Map.Entry<String, AtomicInteger> e : engines.entrySet()) {
                if (this.initTreshold != null && e.getValue().get() < this.initTreshold) continue;
                map.put(e.getKey(), e.getValue().get());
            }
        }
        return map;
    }

    public Map<String, Integer> getQueryEnginesToInit(Integer treshold) {
        return this.getEnginesToInit(this.queryEngines, treshold);
    }

    public Map<String, Integer> getCrudEnginesToInit(Integer treshold) {
        return this.getEnginesToInit(this.crudEngines, treshold);
    }

    public Map<String, Integer> getProcedureEnginesToInit(Integer treshold) {
        return this.getEnginesToInit(this.procedureEngines, treshold);
    }

    public String toString() {
        return "SqlEngineConfiguration [queryEngines=" + this.queryEngines + ", crudEngines=" + this.crudEngines + ", procedureEngines=" + this.procedureEngines + ", dynamicQueryEngines=" + this.dynamicQueryEngines + ", dynamicCrudEngines=" + this.dynamicCrudEngines + ", dynamicProcedureEngines=" + this.dynamicProcedureEngines + ", lazyInit=" + this.lazyInit + ", asyncInitThreads=" + this.asyncInitThreads + ", initTreshold=" + this.initTreshold + ", initInUsageOrder=" + this.initInUsageOrder + ", initClearUsage=" + this.initClearUsage + "]";
    }

    public class NameValue
    implements Comparable<NameValue> {
        public String name;
        public int value;

        public NameValue(String name, Integer value) {
            this.name = name;
            this.value = value != null ? value : 0;
        }

        @Override
        public int compareTo(NameValue o) {
            if (this.value < o.value) {
                return 1;
            }
            if (this.value > o.value) {
                return -1;
            }
            return 0;
        }
    }
}

