/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.config.SqlEngineConfiguration;
import org.sqlproc.engine.impl.SqlEmptyMonitor;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SimpleSqlPluginFactory;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidator;

public abstract class SqlEngine {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String name;
    protected SqlMetaStatement statement;
    protected SqlMappingRule mapping;
    protected Map<String, Object> features = new HashMap<String, Object>();
    protected SqlMonitor monitor;
    protected SqlValidator validator;
    protected SqlTypeFactory typeFactory;
    protected SqlPluginFactory pluginFactory;
    protected ConcurrentHashMap<String, SqlProcessResult> processingCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, AtomicLong> processingCacheStatistics = new ConcurrentHashMap();
    private SqlEngineConfiguration configuration;

    public SqlEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, SqlEngineConfiguration configuration) {
        this.name = name;
        this.statement = statement;
        this.mapping = mapping;
        if (features != null) {
            for (Map.Entry<String, Object> feature : features.entrySet()) {
                this.setFeature(feature.getKey(), feature.getValue());
            }
        }
        this.monitor = monitor != null ? monitor : new SqlEmptyMonitor();
        this.typeFactory = typeFactory;
        this.pluginFactory = pluginFactory != null ? pluginFactory : SimpleSqlPluginFactory.getInstance();
        this.configuration = configuration;
    }

    public void setValidator(SqlValidator validator) {
        this.validator = validator;
    }

    public void setFeature(String name, Object value) {
        this.features.put(name, value);
        this.unsetFeatures(SqlUtils.oppositeFeatures(name));
    }

    public void unsetFeatures(Set<String> names) {
        if (names != null) {
            for (String name : names) {
                this.features.remove(name);
            }
        }
    }

    public static Object getStaticInputValues(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getStaticInputValues();
    }

    public static Object getDynamicUpdateValues(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getDynamicUpdateValues();
    }

    public static Integer getMaxTimeout(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getMaxTimeout();
    }

    public static Integer getFirstResult(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getFirstResult();
    }

    public static Integer getMaxResults(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getMaxResults();
    }

    public static SqlOrder getOrder(SqlControl sqlControl) {
        if (sqlControl == null || sqlControl.getOrder() == null) {
            return SqlQueryEngine.NO_ORDER;
        }
        return sqlControl.getOrder();
    }

    public static Map<String, Class<?>> getMoreResultClasses(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getMoreResultClasses();
    }

    public static Map<String, Object> getFeatures(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getFeatures();
    }

    public static Integer getFetchSize(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getFetchSize();
    }

    void checkDynamicInputValues(Object dynamicInputValues) {
        if (dynamicInputValues == null) {
            return;
        }
        if (dynamicInputValues instanceof SqlOrder) {
            throw new InvalidParameterException("SqlOrder used as dynamic input values");
        }
        if (dynamicInputValues instanceof SqlControl) {
            throw new InvalidParameterException("SqlControl used as dynamic input values");
        }
    }

    void checkStaticInputValues(Object staticInputValues) {
        if (staticInputValues == null) {
            return;
        }
        if (staticInputValues instanceof SqlOrder) {
            throw new InvalidParameterException("SqlOrder used as static input values");
        }
        if (staticInputValues instanceof SqlControl) {
            throw new InvalidParameterException("SqlControl used as static input values");
        }
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public SqlTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public SqlPluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public ConcurrentHashMap<String, SqlProcessResult> getProcessingCache() {
        return this.processingCache;
    }

    public void setProcessingCache(ConcurrentHashMap<String, SqlProcessResult> processingCache) {
        this.processingCache = processingCache;
    }

    public ConcurrentHashMap<String, AtomicLong> getProcessingCacheStatistics() {
        return this.processingCacheStatistics;
    }

    public void setProcessingCacheStatistics(ConcurrentHashMap<String, AtomicLong> processingCacheStatistics) {
        this.processingCacheStatistics = processingCacheStatistics;
    }

    protected SqlProcessResult process(SqlMetaStatement.Type sqlStatementType, Object dynamicInputValues, SqlControl sqlControl) {
        SqlProcessResult firstProcessResult;
        SqlProcessResult processResult = null;
        String processingId = null;
        if (this.configuration != null && this.configuration.getUseProcessingCache() != null && this.configuration.getUseProcessingCache().booleanValue()) {
            boolean doGetProcessingId = false;
            if (!this.configuration.getDoProcessingCacheEngines().isEmpty()) {
                if (this.configuration.getDoProcessingCacheEngines().contains(this.name)) {
                    doGetProcessingId = true;
                }
            } else if (!this.configuration.getDontProcessingCacheEngines().isEmpty()) {
                if (!this.configuration.getDontProcessingCacheEngines().contains(this.name)) {
                    doGetProcessingId = true;
                }
            } else {
                doGetProcessingId = true;
            }
            if (doGetProcessingId) {
                processingId = this.pluginFactory.getSqlProcessingIdPlugin().getProcessingId(this.name, dynamicInputValues, sqlControl, this.configuration.getUseDynamicProcessingCache());
            }
        }
        if (processingId != null) {
            processResult = this.processingCache.get(processingId);
        }
        if (processResult != null) {
            this.processingCacheStatistics.get(processingId).incrementAndGet();
            return new SqlProcessResult(processResult, dynamicInputValues, sqlControl);
        }
        processResult = this.statement.process(sqlStatementType, dynamicInputValues, sqlControl, this);
        if (processingId == null) {
            return processResult;
        }
        AtomicLong firstCounter = this.processingCacheStatistics.putIfAbsent(processingId, new AtomicLong(1L));
        if (firstCounter != null) {
            this.processingCacheStatistics.get(processingId).addAndGet(firstCounter.get());
        }
        return (firstProcessResult = this.processingCache.putIfAbsent(processingId, processResult)) != null ? firstProcessResult : processResult;
    }
}

